/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.archive.crawler.framework.CrawlJob;
import org.archive.util.ArchiveUtils;

public class Engine {
    private static final long serialVersionUID = 4L;
    public static final String LOGS_DIR_NAME = "logs subdirectory";
    public static final String REPORTS_DIR_NAME = "reports subdirectory";
    private static final Logger LOGGER = Logger.getLogger(Engine.class.getName());
    protected File jobsDir;
    protected HashMap<String, CrawlJob> jobConfigs = new HashMap();
    protected String profileCxmlPath = "/org/archive/crawler/restlet/profile-crawler-beans.cxml";

    public Engine(File jobsDir) {
        this.jobsDir = jobsDir;
        try {
            org.archive.util.FileUtils.ensureWriteableDirectory((File)jobsDir);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.findJobConfigs();
    }

    public void findJobConfigs() {
        for (String jobName : this.jobConfigs.keySet().toArray(new String[0])) {
            CrawlJob cj = this.jobConfigs.get(jobName);
            if (cj.getJobDir().exists()) continue;
            this.jobConfigs.remove(jobName);
        }
        if (!this.jobsDir.exists()) {
            LOGGER.log(Level.SEVERE, "jobsDir has disappeared: " + this.jobsDir.toString());
            return;
        }
        Object[] objectArray = this.jobsDir.listFiles();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object candidateFile;
            Object jobFile = candidateFile = objectArray[i];
            if (((File)candidateFile).getName().endsWith(".jobpath")) {
                jobFile = this.getJobDirectoryFrom((File)candidateFile);
            }
            if (this.jobConfigs.containsKey(((File)jobFile).getName()) || this.addJobDirectory((File)jobFile)) continue;
            LOGGER.log(Level.WARNING, "invalid job directory: " + jobFile + " where job expected from: " + candidateFile);
        }
    }

    protected File getJobDirectoryFrom(File jobPathFile) {
        try {
            return new File(FileUtils.readFileToString((File)jobPathFile).trim());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "bad .jobpath: " + jobPathFile, e);
            return null;
        }
    }

    public boolean addJobDirectory(File dir) {
        if (dir == null) {
            return false;
        }
        File[] candidateConfigs = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".cxml");
            }
        });
        if (candidateConfigs == null || candidateConfigs.length == 0) {
            return false;
        }
        if (this.jobConfigs.containsKey(dir.getName())) {
            return false;
        }
        for (File cxml : candidateConfigs) {
            try {
                CrawlJob cj = new CrawlJob(cxml);
                if (!cj.getJobDir().getParentFile().equals(this.getJobsDir())) {
                    this.writeJobPathFile(cj);
                }
                this.jobConfigs.put(cj.getShortName(), cj);
                LOGGER.log(Level.INFO, "added crawl job: " + cj.getShortName());
                return true;
            }
            catch (IOException iae) {
                LOGGER.log(Level.SEVERE, "unable to add job directory" + dir, iae);
            }
            catch (IllegalArgumentException iae) {
                LOGGER.log(Level.SEVERE, "bad cxml: " + cxml, iae);
            }
        }
        return false;
    }

    public Map<String, CrawlJob> getJobConfigs() {
        return this.jobConfigs;
    }

    public synchronized void copy(CrawlJob orig, File destDir, boolean asProfile) throws IOException {
        org.archive.util.FileUtils.ensureWriteableDirectory((File)destDir);
        if (destDir.list().length > 0) {
            throw new IOException("destination dir not empty");
        }
        File srcDir = orig.getPrimaryConfig().getParentFile();
        FileUtils.copyDirectory((File)srcDir, (File)destDir, (FileFilter)FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.fileFileFilter(), (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.prefixFileFilter((String)"job.log"))));
        File srcResources = new File(srcDir, "resources");
        if (srcResources.isDirectory()) {
            FileUtils.copyDirectory((File)srcResources, (File)new File(destDir, "resources"));
        }
        File newPrimaryConfig = new File(destDir, orig.getPrimaryConfig().getName());
        if (asProfile) {
            if (!orig.isProfile()) {
                FileUtils.moveFile((File)newPrimaryConfig, (File)new File(destDir, "profile-" + newPrimaryConfig.getName()));
            }
        } else if (orig.isProfile()) {
            FileUtils.moveFile((File)newPrimaryConfig, (File)new File(destDir, newPrimaryConfig.getName().substring(8)));
        }
        this.findJobConfigs();
    }

    public void copy(CrawlJob cj, String copyTo, boolean asProfile) throws IOException {
        File dest = new File(copyTo);
        if (!dest.isAbsolute()) {
            dest = new File(this.jobsDir, copyTo);
        }
        this.copy(cj, dest, asProfile);
    }

    public String getHeritrixVersion() {
        return ArchiveUtils.VERSION;
    }

    public synchronized void deleteJob(CrawlJob job) throws IOException {
        FileUtils.deleteDirectory((File)job.getJobDir());
    }

    public void requestLaunch(String shortName) {
        this.jobConfigs.get(shortName).launch();
    }

    public CrawlJob getJob(String shortName) {
        if (!this.jobConfigs.containsKey(shortName)) {
            this.findJobConfigs();
        }
        return this.jobConfigs.get(shortName);
    }

    public File getJobsDir() {
        return this.jobsDir;
    }

    public Map<String, Object> heapReportData() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("usedBytes", Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
        map.put("totalBytes", Runtime.getRuntime().totalMemory());
        map.put("maxBytes", Runtime.getRuntime().maxMemory());
        return map;
    }

    public String heapReport() {
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long maxMemory = Runtime.getRuntime().maxMemory();
        StringBuilder sb = new StringBuilder(64);
        sb.append((totalMemory - freeMemory) / 1024L).append(" KiB used; ").append(totalMemory / 1024L).append(" KiB current heap; ").append(maxMemory / 1024L).append(" KiB max heap");
        return sb.toString();
    }

    public void shutdown() {
        for (CrawlJob job : this.jobConfigs.values()) {
            if (!job.isRunning()) continue;
            job.terminate();
        }
        this.waitForNoRunningJobs(0L);
    }

    public boolean waitForNoRunningJobs(long timeout) {
        long startTime = System.currentTimeMillis();
        block4: while (true) {
            if (timeout > 0L && startTime + timeout > System.currentTimeMillis()) {
                return true;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                break;
            }
            for (CrawlJob job : this.jobConfigs.values()) {
                if (!job.isRunning()) continue;
                continue block4;
            }
            break;
        }
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    protected InputStream getProfileCxmlResource() {
        return this.getClass().getResourceAsStream(this.profileCxmlPath);
    }

    public boolean createNewJobWithDefaults(File newJobDir) {
        try {
            InputStream inStream = this.getProfileCxmlResource();
            String defaultCxmlStr = IOUtils.toString((InputStream)inStream);
            inStream.close();
            org.archive.util.FileUtils.ensureWriteableDirectory((File)newJobDir);
            File newJobCxml = new File(newJobDir, "crawler-beans.cxml");
            FileUtils.writeStringToFile((File)newJobCxml, (String)defaultCxmlStr);
            return true;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "failed to create new job: " + newJobDir.getAbsolutePath());
            return false;
        }
    }

    public void writeJobPathFile(CrawlJob job) throws IOException {
        String jobpathFileName = job.getShortName() + ".jobpath";
        File jobpathFile = new File(this.jobsDir, jobpathFileName);
        FileUtils.writeStringToFile((File)jobpathFile, (String)(job.getJobDir().getAbsolutePath() + "\n"));
        LOGGER.log(Level.INFO, "wrote jobpath file: " + jobpathFileName);
    }
}

