/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import com.sleepycat.util.RuntimeExceptionWrapper;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.crawler.framework.CrawlController;
import org.archive.crawler.framework.ToePool;
import org.archive.io.SinkHandlerLogThread;
import org.archive.modules.CrawlURI;
import org.archive.modules.Processor;
import org.archive.modules.ProcessorChain;
import org.archive.modules.fetcher.HostResolver;
import org.archive.spring.KeyedProperties;
import org.archive.spring.OverlayContext;
import org.archive.util.ArchiveUtils;
import org.archive.util.DevUtils;
import org.archive.util.ProgressStatisticsReporter;
import org.archive.util.Recorder;
import org.archive.util.ReportUtils;
import org.archive.util.Reporter;

public class ToeThread
extends Thread
implements Reporter,
ProgressStatisticsReporter,
HostResolver,
SinkHandlerLogThread,
ProcessorChain.ChainStatusReceiver {
    private static Logger logger = Logger.getLogger("org.archive.crawler.framework.ToeThread");
    private CrawlController controller;
    private int serialNumber;
    private Recorder httpRecorder = null;
    private Step step = Step.NASCENT;
    private long atStepSince;
    private String currentProcessorName = "";
    private String coreName;
    private CrawlURI currentCuri;
    private long lastStartTime;
    private long lastFinishTime;
    private static final int DEFAULT_PRIORITY = 3;
    private volatile boolean shouldRetire = false;

    public ToeThread(ToePool g, int sn) {
        super((ThreadGroup)g, "ToeThread #" + sn);
        this.coreName = "ToeThread #" + sn + ": ";
        this.controller = g.getController();
        this.serialNumber = sn;
        this.setPriority(3);
        int outBufferSize = this.controller.getRecorderOutBufferBytes();
        int inBufferSize = this.controller.getRecorderInBufferBytes();
        this.httpRecorder = new Recorder(this.controller.getScratchDir().getFile(), "tt" + sn + "http", outBufferSize, inBufferSize);
        this.lastFinishTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String name = this.controller.getMetadata().getJobName();
        logger.fine(this.getName() + " started for order '" + name + "'");
        Recorder.setHttpRecorder((Recorder)this.httpRecorder);
        try {
            do {
                ToeThread toeThread;
                Object curi;
                block49: {
                    ArchiveUtils.continueCheck();
                    this.setStep(Step.ABOUT_TO_GET_URI, null);
                    curi = this.controller.getFrontier().next();
                    toeThread = this;
                    synchronized (toeThread) {
                        this.setCurrentCuri((CrawlURI)curi);
                        ArchiveUtils.continueCheck();
                        this.currentCuri.setThreadNumber(this.serialNumber);
                        this.lastStartTime = System.currentTimeMillis();
                        this.currentCuri.setRecorder(this.httpRecorder);
                    }
                    try {
                        KeyedProperties.loadOverridesFrom((OverlayContext)curi);
                        this.controller.getFetchChain().process(curi, (ProcessorChain.ChainStatusReceiver)this);
                        this.controller.getFrontier().beginDisposition((CrawlURI)curi);
                        this.controller.getDispositionChain().process(curi, (ProcessorChain.ChainStatusReceiver)this);
                    }
                    catch (RuntimeExceptionWrapper e) {
                        if (e.getCause() == null) {
                            e.initCause(e.getCause());
                        }
                        this.recoverableProblem(e);
                    }
                    catch (AssertionError ae) {
                        this.recoverableProblem((Throwable)((Object)ae));
                    }
                    catch (RuntimeException e) {
                        this.recoverableProblem(e);
                    }
                    catch (InterruptedException e) {
                        if (this.currentCuri != null) {
                            this.recoverableProblem(e);
                            Thread.interrupted();
                            break block49;
                        }
                        throw e;
                    }
                    catch (StackOverflowError err) {
                        this.recoverableProblem(err);
                    }
                    catch (Error err) {
                        this.seriousError(err);
                    }
                    finally {
                        this.httpRecorder.endReplays();
                        KeyedProperties.clearOverridesFrom((OverlayContext)curi);
                    }
                }
                this.setStep(Step.ABOUT_TO_RETURN_URI, null);
                ArchiveUtils.continueCheck();
                toeThread = this;
                synchronized (toeThread) {
                    this.controller.getFrontier().finished(this.currentCuri);
                    this.controller.getFrontier().endDisposition();
                    this.setCurrentCuri(null);
                }
                curi = null;
                this.setStep(Step.FINISHING_PROCESS, null);
                this.lastFinishTime = System.currentTimeMillis();
            } while (!this.shouldRetire);
        }
        catch (InterruptedException e) {
            logger.log(Level.FINE, this.getName() + " ended with Interruption");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Fatal exception in " + this.getName(), e);
        }
        catch (OutOfMemoryError err) {
            this.seriousError(err);
        }
        finally {
            ToeThread e = this;
            synchronized (e) {
                if (this.currentCuri != null) {
                    logger.log(Level.WARNING, "Leaving with unfinished CrawlURI " + this.getName() + " - attempting to finish");
                    this.currentCuri.setFetchStatus(-7000);
                    this.controller.getFrontier().finished(this.currentCuri);
                    this.setCurrentCuri(null);
                }
            }
            this.controller.getFrontier().endDisposition();
        }
        this.setCurrentCuri(null);
        this.httpRecorder.closeRecorders();
        this.httpRecorder = null;
        logger.fine(this.getName() + " finished for order '" + name + "'");
        this.setStep(Step.FINISHED, null);
        this.controller = null;
    }

    private void setCurrentCuri(CrawlURI curi) {
        if (curi == null) {
            this.setName(this.coreName);
        } else {
            this.setName(this.coreName + curi);
        }
        this.currentCuri = curi;
    }

    public void setStep(Step s, String procName) {
        this.step = s;
        this.atStepSince = System.currentTimeMillis();
        this.currentProcessorName = procName != null ? procName : "";
    }

    public void atProcessor(Processor proc) {
        this.setStep(Step.ABOUT_TO_BEGIN_PROCESSOR, proc.getBeanName());
    }

    private void seriousError(Error err) {
        this.setPriority(4);
        if (this.controller != null) {
            this.controller.freeReserveMemory();
            this.controller.requestCrawlPause();
            if (this.controller.getFrontier().getFrontierJournal() != null) {
                this.controller.getFrontier().getFrontierJournal().seriousError(this.getName() + err.getMessage());
            }
        }
        String extraInfo = DevUtils.extraInfo();
        System.err.println("<<<");
        System.err.println(ArchiveUtils.getLog17Date());
        System.err.println(err);
        System.err.println(extraInfo);
        err.printStackTrace(System.err);
        if (this.controller != null) {
            PrintWriter pw = new PrintWriter(System.err);
            this.controller.getToePool().compactReportTo(pw);
            pw.flush();
        }
        System.err.println(">>>");
        String context = "unknown";
        if (this.currentCuri != null) {
            this.currentCuri.getAnnotations().add("err=" + err.getClass().getName());
            this.currentCuri.getAnnotations().add("os" + this.currentCuri.getFetchStatus());
            this.currentCuri.setFetchStatus(-3000);
            context = this.currentCuri.shortReportLine() + " in " + this.currentProcessorName;
        }
        String message = "Serious error occurred trying to process '" + context + "'\n" + extraInfo;
        logger.log(Level.SEVERE, message.toString(), err);
        this.setPriority(3);
    }

    private void recoverableProblem(Throwable e) {
        Step previousStep = this.step;
        this.setStep(Step.HANDLING_RUNTIME_EXCEPTION, null);
        this.currentCuri.setFetchStatus(-5);
        this.currentCuri.getAnnotations().add("err=" + e.getClass().getName());
        this.currentCuri.getData().put("runtime-exception", e);
        String message = "Problem " + e + " occurred when trying to process '" + this.currentCuri.toString() + "' at step " + (Object)((Object)previousStep) + " in " + this.currentProcessorName + "\n";
        logger.log(Level.SEVERE, message.toString(), e);
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public CrawlController getController() {
        return this.controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void kill() {
        this.interrupt();
        ToeThread toeThread = this;
        synchronized (toeThread) {
            if (this.currentCuri != null) {
                this.currentCuri.setFetchStatus(-7000);
                this.controller.getFrontier().finished(this.currentCuri);
            }
        }
    }

    public Object getStep() {
        return this.step;
    }

    public boolean isActive() {
        return this.isAlive() && this.currentCuri != null && !this.isInterrupted();
    }

    public void retire() {
        this.shouldRetire = true;
    }

    public boolean shouldRetire() {
        return this.shouldRetire;
    }

    public void reportTo(PrintWriter pw) {
        pw.print("[");
        pw.println(this.getName());
        CrawlURI c = this.currentCuri;
        if (c != null) {
            pw.print(" ");
            c.shortReportLineTo(pw);
            pw.print("    ");
            pw.print(c.getFetchAttempts());
            pw.print(" attempts");
            pw.println();
            pw.print("    ");
            pw.print("in processor: ");
            pw.print(this.currentProcessorName);
        } else {
            pw.print(" -no CrawlURI- ");
        }
        pw.println();
        long now = System.currentTimeMillis();
        long time = 0L;
        pw.print("    ");
        if (this.lastFinishTime > this.lastStartTime) {
            pw.print("WAITING for ");
            time = now - this.lastFinishTime;
        } else if (this.lastStartTime > 0L) {
            pw.print("ACTIVE for ");
            time = now - this.lastStartTime;
        }
        pw.print(ArchiveUtils.formatMillisecondsToConventional((long)time));
        pw.println();
        pw.print("    ");
        pw.print("step: ");
        pw.print((Object)this.step);
        pw.print(" for ");
        pw.print(ArchiveUtils.formatMillisecondsToConventional((long)(System.currentTimeMillis() - this.atStepSince)));
        pw.println();
        ToeThread.reportThread(this, pw);
        pw.print("]");
        pw.println();
        pw.flush();
    }

    public static void reportThread(Thread t, PrintWriter pw) {
        ThreadMXBean tmxb = ManagementFactory.getThreadMXBean();
        ThreadInfo info = tmxb.getThreadInfo(t.getId());
        pw.print("Java Thread State: ");
        pw.println((Object)info.getThreadState());
        pw.print("Blocked/Waiting On: ");
        if (info.getLockOwnerId() >= 0L) {
            pw.print(info.getLockName());
            pw.print(" which is owned by ");
            pw.print(info.getLockOwnerName());
            pw.print("(");
            pw.print(info.getLockOwnerId());
            pw.println(")");
        } else {
            pw.println("NONE");
        }
        StackTraceElement[] ste = t.getStackTrace();
        for (int i = 0; i < ste.length; ++i) {
            pw.print("    ");
            pw.print(ste[i].toString());
            pw.println();
        }
    }

    public Map<String, Object> shortReportMap() {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("serialNumber", this.serialNumber);
        CrawlURI c = this.currentCuri;
        if (c != null) {
            data.put("currentURI", c.toString());
            data.put("currentProcessor", this.currentProcessorName);
            data.put("fetchAttempts", c.getFetchAttempts());
        } else {
            data.put("currentURI", null);
        }
        long now = System.currentTimeMillis();
        long time = 0L;
        if (this.lastFinishTime > this.lastStartTime) {
            data.put("status", "WAITING");
            time = now - this.lastFinishTime;
        } else if (this.lastStartTime > 0L) {
            data.put("status", "ACTIVE");
            time = now - this.lastStartTime;
        }
        data.put("currentStatusElapsedMilliseconds", time);
        data.put("currentStatusElapsedPretty", ArchiveUtils.formatMillisecondsToConventional((long)time));
        data.put("step", (Object)this.step);
        return data;
    }

    public void shortReportLineTo(PrintWriter w) {
        w.print("#");
        w.print(this.serialNumber);
        CrawlURI c = this.currentCuri;
        if (c != null) {
            w.print(" ");
            w.print(this.currentProcessorName);
            w.print(" ");
            w.print(c.toString());
            w.print(" (");
            w.print(c.getFetchAttempts());
            w.print(") ");
        } else {
            w.print(" [no CrawlURI] ");
        }
        long now = System.currentTimeMillis();
        long time = 0L;
        if (this.lastFinishTime > this.lastStartTime) {
            w.print("WAITING for ");
            time = now - this.lastFinishTime;
        } else if (this.lastStartTime > 0L) {
            w.print("ACTIVE for ");
            time = now - this.lastStartTime;
        }
        w.print(ArchiveUtils.formatMillisecondsToConventional((long)time));
        w.print(" at ");
        w.print((Object)this.step);
        w.print(" for ");
        w.print(ArchiveUtils.formatMillisecondsToConventional((long)(now - this.atStepSince)));
        w.print("\n");
        w.flush();
    }

    public String shortReportLegend() {
        return "#serialNumber processorName currentUri (fetchAttempts) threadState threadStep";
    }

    public String shortReportLine() {
        return ReportUtils.shortReportLine((Reporter)this);
    }

    public void progressStatisticsLine(PrintWriter writer) {
        writer.print(this.getController().getStatisticsTracker().getSnapshot().getProgressStatisticsLine());
        writer.print("\n");
    }

    public void progressStatisticsLegend(PrintWriter writer) {
        writer.print(this.getController().getStatisticsTracker().progressStatisticsLegend());
        writer.print("\n");
    }

    public String getCurrentProcessorName() {
        return this.currentProcessorName;
    }

    public InetAddress resolve(String host) {
        return this.controller.getServerCache().getHostFor(host).getIP();
    }

    public static enum Step {
        NASCENT,
        ABOUT_TO_GET_URI,
        FINISHED,
        ABOUT_TO_BEGIN_PROCESSOR,
        HANDLING_RUNTIME_EXCEPTION,
        ABOUT_TO_RETURN_URI,
        FINISHING_PROCESS;

    }
}

