/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URIException;
import org.archive.crawler.datamodel.UriUniqFilter;
import org.archive.crawler.event.CrawlStateEvent;
import org.archive.crawler.framework.CrawlController;
import org.archive.crawler.framework.Frontier;
import org.archive.crawler.frontier.FrontierJournal;
import org.archive.crawler.frontier.WorkQueue;
import org.archive.crawler.prefetch.FrontierPreparer;
import org.archive.crawler.reporting.CrawlerLoggerModule;
import org.archive.crawler.spring.SheetOverlaysManager;
import org.archive.modules.CrawlURI;
import org.archive.modules.deciderules.DecideRule;
import org.archive.modules.extractor.ExtractorParameters;
import org.archive.modules.fetcher.FetchStats;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.CrawlServer;
import org.archive.modules.net.ServerCache;
import org.archive.modules.seeds.SeedListener;
import org.archive.modules.seeds.SeedModule;
import org.archive.spring.HasKeyedProperties;
import org.archive.spring.KeyedProperties;
import org.archive.spring.OverlayContext;
import org.archive.util.ArchiveUtils;
import org.archive.util.ReportUtils;
import org.archive.util.Reporter;
import org.archive.util.iterator.LineReadingIterator;
import org.archive.util.iterator.RegexLineIterator;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public abstract class AbstractFrontier
implements Frontier,
SeedListener,
HasKeyedProperties,
ExtractorParameters,
UriUniqFilter.CrawlUriReceiver,
ApplicationListener<ApplicationEvent> {
    private static final long serialVersionUID = 555881755284996860L;
    private static final Logger logger = Logger.getLogger(AbstractFrontier.class.getName());
    protected KeyedProperties kp = new KeyedProperties();
    protected CrawlController controller;
    protected SheetOverlaysManager sheetOverlaysManager;
    protected CrawlerLoggerModule loggerModule;
    protected SeedModule seeds;
    protected ServerCache serverCache;
    protected AtomicLong nextOrdinal;
    protected DecideRule scope;
    protected FrontierPreparer preparer;
    protected AtomicLong queuedUriCount;
    protected AtomicLong futureUriCount;
    protected AtomicLong succeededFetchCount;
    protected AtomicLong failedFetchCount;
    protected AtomicLong disregardedUriCount;
    protected AtomicLong totalProcessedBytes;
    protected AtomicLong queueReadiedCount;
    protected FrontierJournal recover;
    protected ReentrantReadWriteLock outboundLock;
    protected Thread managerThread;
    protected Frontier.State lastReachedState;
    protected volatile Frontier.State targetState;
    private static final int PROGRESS_INTERVAL = 1000000;
    protected ReentrantReadWriteLock dispositionInProgressLock;
    protected ThreadLocal<CrawlURI> dispositionPending;

    public KeyedProperties getKeyedProperties() {
        return this.kp;
    }

    public int getRetryDelaySeconds() {
        return (Integer)this.kp.get("retryDelaySeconds");
    }

    public void setRetryDelaySeconds(int delay) {
        this.kp.put((Object)"retryDelaySeconds", (Object)delay);
    }

    public int getMaxRetries() {
        return (Integer)this.kp.get("maxRetries");
    }

    public void setMaxRetries(int maxRetries) {
        this.kp.put((Object)"maxRetries", (Object)maxRetries);
    }

    public boolean getRecoveryLogEnabled() {
        return (Boolean)this.kp.get("recoveryLogEnabled");
    }

    public void setRecoveryLogEnabled(boolean enabled) {
        this.kp.put((Object)"recoveryLogEnabled", (Object)enabled);
    }

    public int getMaxOutlinks() {
        return (Integer)this.kp.get("maxOutlinks");
    }

    public void setMaxOutlinks(int max) {
        this.kp.put((Object)"maxOutlinks", (Object)max);
    }

    public boolean getExtractIndependently() {
        return (Boolean)this.kp.get("extractIndependently");
    }

    public void setExtractIndependently(boolean extractIndependently) {
        this.kp.put((Object)"extractIndependently", (Object)extractIndependently);
    }

    public boolean getExtract404s() {
        return (Boolean)this.kp.get("extract404s");
    }

    public void setExtract404s(boolean extract404s) {
        this.kp.put((Object)"extract404s", (Object)extract404s);
    }

    public boolean isRunning() {
        return this.managerThread != null && this.managerThread.isAlive();
    }

    public void stop() {
        this.terminate();
        ArchiveUtils.closeQuietly((Object)((Object)this.recover));
    }

    public CrawlController getCrawlController() {
        return this.controller;
    }

    @Autowired
    public void setCrawlController(CrawlController controller) {
        this.controller = controller;
    }

    public SheetOverlaysManager getSheetOverlaysManager() {
        return this.sheetOverlaysManager;
    }

    @Autowired
    public void setSheetOverlaysManager(SheetOverlaysManager sheetOverlaysManager) {
        this.sheetOverlaysManager = sheetOverlaysManager;
    }

    public CrawlerLoggerModule getLoggerModule() {
        return this.loggerModule;
    }

    @Autowired
    public void setLoggerModule(CrawlerLoggerModule loggerModule) {
        this.loggerModule = loggerModule;
    }

    public SeedModule getSeeds() {
        return this.seeds;
    }

    @Autowired
    public void setSeeds(SeedModule seeds) {
        this.seeds = seeds;
    }

    public ServerCache getServerCache() {
        return this.serverCache;
    }

    @Autowired
    public void setServerCache(ServerCache serverCache) {
        this.serverCache = serverCache;
    }

    @Override
    public DecideRule getScope() {
        return this.scope;
    }

    @Autowired
    public void setScope(DecideRule scope) {
        this.scope = scope;
    }

    public FrontierPreparer getFrontierPreparer() {
        return this.preparer;
    }

    @Autowired
    public void setFrontierPreparer(FrontierPreparer prep) {
        this.preparer = prep;
    }

    @Override
    public String getClassKey(CrawlURI curi) {
        assert (KeyedProperties.overridesActiveFrom((OverlayContext)curi));
        return this.preparer.getClassKey(curi);
    }

    public AbstractFrontier() {
        this.setRetryDelaySeconds(900);
        this.setMaxRetries(30);
        this.setRecoveryLogEnabled(true);
        this.setMaxOutlinks(6000);
        this.setExtractIndependently(false);
        this.setExtract404s(true);
        this.nextOrdinal = new AtomicLong(1L);
        this.queuedUriCount = new AtomicLong(0L);
        this.futureUriCount = new AtomicLong(0L);
        this.succeededFetchCount = new AtomicLong(0L);
        this.failedFetchCount = new AtomicLong(0L);
        this.disregardedUriCount = new AtomicLong(0L);
        this.totalProcessedBytes = new AtomicLong(0L);
        this.queueReadiedCount = new AtomicLong(0L);
        this.recover = null;
        this.outboundLock = new ReentrantReadWriteLock(true);
        this.lastReachedState = null;
        this.targetState = Frontier.State.PAUSE;
        this.dispositionInProgressLock = new ReentrantReadWriteLock(true);
        this.dispositionPending = new ThreadLocal();
    }

    protected void startManagerThread() {
        this.managerThread = new Thread(this + ".managerThread"){

            @Override
            public void run() {
                AbstractFrontier.this.managementTasks();
            }
        };
        this.managerThread.setPriority(6);
        this.managerThread.start();
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        if (this.getRecoveryLogEnabled()) {
            try {
                this.initJournal(this.loggerModule.getPath().getFile().getAbsolutePath());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        this.pause();
        this.startManagerThread();
    }

    protected void managementTasks() {
        block21: {
            assert (Thread.currentThread() == this.managerThread);
            try {
                while (true) {
                    try {
                        while (true) {
                            Frontier.State reachedState = null;
                            switch (this.targetState) {
                                case EMPTY: {
                                    reachedState = Frontier.State.EMPTY;
                                }
                                case RUN: {
                                    while (this.outboundLock.isWriteLockedByCurrentThread()) {
                                        this.outboundLock.writeLock().unlock();
                                    }
                                    if (reachedState == null) {
                                        reachedState = Frontier.State.RUN;
                                    }
                                    this.reachedState(reachedState);
                                    Thread.sleep(250L);
                                    if (this.isEmpty() && this.targetState == Frontier.State.RUN) {
                                        this.requestState(Frontier.State.EMPTY);
                                        break;
                                    }
                                    if (!this.isEmpty() && this.targetState == Frontier.State.EMPTY) {
                                        this.requestState(Frontier.State.RUN);
                                    }
                                    break;
                                }
                                case HOLD: 
                                case PAUSE: {
                                    this.outboundLock.writeLock().lock();
                                    while (this.targetState == Frontier.State.PAUSE) {
                                        if (this.getInProcessCount() == 0) {
                                            this.reachedState(Frontier.State.PAUSE);
                                        }
                                        Thread.sleep(250L);
                                    }
                                    break;
                                }
                                case FINISH: {
                                    logger.fine("FINISH requested, waiting for in process urls to finish");
                                    this.outboundLock.writeLock().lock();
                                    while (this.getInProcessCount() > 0) {
                                        Thread.sleep(250L);
                                    }
                                    logger.fine("0 urls in process, running final tasks");
                                    this.finalTasks();
                                    this.reachedState(Frontier.State.FINISH);
                                    break block21;
                                }
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        logger.log(Level.SEVERE, "", e);
                        if (this.targetState == Frontier.State.PAUSE || this.targetState == Frontier.State.FINISH) continue;
                        this.requestState(Frontier.State.PAUSE);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.targetState = Frontier.State.PAUSE;
        while (this.outboundLock.isWriteLockedByCurrentThread()) {
            this.outboundLock.writeLock().unlock();
        }
        logger.log(Level.FINE, "ending frontier mgr thread");
    }

    protected void finalTasks() {
    }

    protected void reachedState(Frontier.State justReached) {
        if (justReached != this.lastReachedState) {
            logger.fine("reached Frontier.State " + (Object)((Object)this.lastReachedState) + ", notifying listeners");
            this.controller.noteFrontierState(justReached);
            this.lastReachedState = justReached;
        }
    }

    @Override
    public CrawlURI next() throws InterruptedException {
        CrawlURI crawlable = null;
        while (crawlable == null) {
            this.outboundLock.readLock().lockInterruptibly();
            crawlable = this.findEligibleURI();
            this.outboundLock.readLock().unlock();
        }
        return crawlable;
    }

    protected abstract CrawlURI findEligibleURI();

    protected abstract void processScheduleAlways(CrawlURI var1);

    protected abstract void processScheduleIfUnique(CrawlURI var1);

    protected abstract void processFinish(CrawlURI var1);

    protected abstract int getInProcessCount();

    protected abstract long getMaxInWait();

    @Override
    public void schedule(CrawlURI curi) {
        this.sheetOverlaysManager.applyOverlaysTo(curi);
        if (curi.getClassKey() == null) {
            try {
                KeyedProperties.loadOverridesFrom((OverlayContext)curi);
                this.preparer.prepare(curi);
                this.processScheduleIfUnique(curi);
            }
            finally {
                KeyedProperties.clearOverridesFrom((OverlayContext)curi);
            }
        }
    }

    @Override
    public void receive(CrawlURI curi) {
        this.sheetOverlaysManager.applyOverlaysTo(curi);
        try {
            KeyedProperties.loadOverridesFrom((OverlayContext)curi);
            this.processScheduleAlways(curi);
        }
        finally {
            KeyedProperties.clearOverridesFrom((OverlayContext)curi);
        }
    }

    @Override
    public void finished(CrawlURI curi) {
        try {
            KeyedProperties.loadOverridesFrom((OverlayContext)curi);
            this.processFinish(curi);
        }
        finally {
            KeyedProperties.clearOverridesFrom((OverlayContext)curi);
        }
    }

    private void initJournal(String logsDisk) throws IOException {
        if (logsDisk != null) {
            String logsPath = logsDisk + File.separatorChar;
            this.recover = new FrontierJournal(logsPath, "frontier.recover.gz");
        }
    }

    @Override
    public void run() {
        this.requestState(Frontier.State.RUN);
    }

    @Override
    public void requestState(Frontier.State target) {
        this.targetState = target;
    }

    @Override
    public void pause() {
        this.requestState(Frontier.State.PAUSE);
    }

    @Override
    public void unpause() {
        this.requestState(Frontier.State.RUN);
    }

    @Override
    public void terminate() {
        this.requestState(Frontier.State.FINISH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tally(CrawlURI curi, FetchStats.Stage stage) {
        Object object;
        block12: {
            CrawlServer server = this.getServerCache().getServerFor(curi.getUURI());
            if (server != null) {
                CrawlServer crawlServer = server;
                synchronized (crawlServer) {
                    server.getSubstats().tally(curi, stage);
                    server.makeDirty();
                }
            }
            try {
                CrawlHost host = this.getServerCache().getHostFor(curi.getUURI());
                if (host == null) break block12;
                object = host;
                synchronized (object) {
                    host.getSubstats().tally(curi, stage);
                    host.makeDirty();
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "unable to tally host stats for " + curi, e);
            }
        }
        Frontier.FrontierGroup group = this.getGroup(curi);
        object = group;
        synchronized (object) {
            group.tally(curi, stage);
            group.makeDirty();
        }
    }

    protected void doJournalFinishedSuccess(CrawlURI c) {
        this.tally(c, FetchStats.Stage.SUCCEEDED);
        if (this.recover != null) {
            this.recover.finishedSuccess(c);
        }
    }

    protected void doJournalAdded(CrawlURI c) {
        this.tally(c, FetchStats.Stage.SCHEDULED);
        if (this.recover != null) {
            this.recover.added(c);
        }
    }

    protected void doJournalRelocated(CrawlURI c) {
        this.tally(c, FetchStats.Stage.RELOCATED);
        if (this.recover != null) {
            // empty if block
        }
    }

    protected void doJournalReenqueued(CrawlURI c) {
        this.tally(c, FetchStats.Stage.RETRIED);
        if (this.recover != null) {
            this.recover.reenqueued(c);
        }
    }

    protected void doJournalFinishedFailure(CrawlURI c) {
        this.tally(c, FetchStats.Stage.FAILED);
        if (this.recover != null) {
            this.recover.finishedFailure(c);
        }
    }

    protected void doJournalDisregarded(CrawlURI c) {
        this.tally(c, FetchStats.Stage.DISREGARDED);
        if (this.recover != null) {
            this.recover.finishedDisregard(c);
        }
    }

    protected void doJournalEmitted(CrawlURI c) {
        if (this.recover != null) {
            this.recover.emitted(c);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.queuedUriCount.get() == 0L;
    }

    protected void incrementQueuedUriCount() {
        this.queuedUriCount.incrementAndGet();
    }

    protected void incrementQueuedUriCount(long increment) {
        this.queuedUriCount.addAndGet(increment);
    }

    protected void decrementQueuedCount(long numberOfDeletes) {
        this.queuedUriCount.addAndGet(-numberOfDeletes);
    }

    @Override
    public long queuedUriCount() {
        return this.queuedUriCount.get();
    }

    @Override
    public long futureUriCount() {
        return this.futureUriCount.get();
    }

    @Override
    public long finishedUriCount() {
        return this.succeededFetchCount.get() + this.failedFetchCount.get() + this.disregardedUriCount.get();
    }

    protected void incrementSucceededFetchCount() {
        this.succeededFetchCount.incrementAndGet();
    }

    @Override
    public long succeededFetchCount() {
        return this.succeededFetchCount.get();
    }

    protected void incrementFailedFetchCount() {
        this.failedFetchCount.incrementAndGet();
    }

    @Override
    public long failedFetchCount() {
        return this.failedFetchCount.get();
    }

    protected void incrementDisregardedUriCount() {
        this.disregardedUriCount.incrementAndGet();
    }

    @Override
    public long disregardedUriCount() {
        return this.disregardedUriCount.get();
    }

    public void addedSeed(CrawlURI puri) {
        this.schedule(puri);
    }

    public boolean nonseedLine(String line) {
        return false;
    }

    public void concludedSeedBatch() {
    }

    protected void prepForFrontier(CrawlURI curi) {
        if (curi.getOrdinal() == 0L) {
            curi.setOrdinal(this.nextOrdinal.getAndIncrement());
        }
    }

    protected void noteAboutToEmit(CrawlURI curi, WorkQueue q) {
        curi.setHolder((Object)q);
        this.doJournalEmitted(curi);
    }

    protected long retryDelayFor(CrawlURI curi) {
        int status = curi.getFetchStatus();
        return status == -2 || status == -3 || status == -1 ? (long)this.getRetryDelaySeconds() : 0L;
    }

    protected void logNonfatalErrors(CrawlURI curi) {
        if (curi.containsDataKey("nonfatal-errors")) {
            Collection x = curi.getNonFatalFailures();
            Logger le = this.loggerModule.getNonfatalErrors();
            for (Throwable e : x) {
                le.log(Level.WARNING, curi.toString(), new Object[]{curi, e});
            }
            curi.getData().remove("nonfatal-errors");
        }
    }

    protected boolean overMaxRetries(CrawlURI curi) {
        return curi.getFetchAttempts() >= this.getMaxRetries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long importRecoverFormat(File source, boolean applyScope, boolean includeOnly, boolean forceFetch, String acceptTags) throws IOException {
        DecideRule scope = applyScope ? this.getScope() : null;
        FrontierJournal newJournal = this.getFrontierJournal();
        Matcher m = Pattern.compile(acceptTags).matcher("");
        int lineCount = 0;
        try (BufferedReader br = ArchiveUtils.getBufferedReader((File)source);){
            String read;
            while ((read = br.readLine()) != null) {
                ++lineCount;
                if (read.length() < 4) continue;
                String lineType = read.substring(0, 3);
                m.reset(lineType);
                if (m.matches()) {
                    try {
                        String uriHopsViaString = read.substring(3).trim();
                        CrawlURI curi = CrawlURI.fromHopsViaString((String)uriHopsViaString);
                        if (scope != null) {
                            this.sheetOverlaysManager.applyOverlaysTo(curi);
                            try {
                                KeyedProperties.loadOverridesFrom((OverlayContext)curi);
                                if (!scope.accepts(curi)) {
                                    continue;
                                }
                            }
                            finally {
                                KeyedProperties.clearOverridesFrom((OverlayContext)curi);
                                continue;
                            }
                        }
                        if (includeOnly) {
                            this.considerIncluded(curi);
                            newJournal.included(curi);
                        } else {
                            curi.setForceFetch(forceFetch);
                            this.schedule(curi);
                        }
                    }
                    catch (URIException e) {
                        logger.log(Level.WARNING, "Problem line: " + read, e);
                    }
                }
                if (lineCount % 1000000 != 0) continue;
                logger.info("at line " + lineCount + (includeOnly ? " (include-only)" : "") + " alreadyIncluded count = " + this.discoveredUriCount());
            }
        }
        return lineCount;
    }

    @Override
    public void importURIs(String jsonParams) throws IOException {
        JSONObject params;
        try {
            params = new JSONObject(jsonParams);
        }
        catch (JSONException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        if ("recoveryLog".equals(params.optString("format"))) {
            FrontierJournal.importRecoverLog(params, this);
            return;
        }
        this.importURIsSimple(params);
    }

    protected void importURIsSimple(JSONObject params) {
        String output;
        String extractor;
        String format = params.optString("format");
        if ("crawlLog".equals(format)) {
            extractor = "\\S+\\s+\\S+\\s+\\S+\\s+(\\S+\\s+\\S+\\s+\\S+\\s+).*";
            output = "$1";
        } else {
            extractor = "^[\\s\ufeff]*(\\S+)\\s*(#.*)?$";
            output = "$1";
        }
        BufferedReader br = null;
        String path = params.optString("path");
        boolean forceRevisit = !params.isNull("forceRevisit");
        boolean asSeeds = !params.isNull("asSeeds");
        boolean scopeScheduleds = !params.isNull("scopeScheduleds");
        DecideRule scope = scopeScheduleds ? this.getScope() : null;
        try {
            br = new BufferedReader(new InputStreamReader(new FileInputStream(path)));
            RegexLineIterator iter = new RegexLineIterator((Iterator)new LineReadingIterator(br), "\\s*(#.*)?", extractor, output);
            while (iter.hasNext()) {
                try {
                    CrawlURI curi = CrawlURI.fromHopsViaString((String)((String)iter.next()));
                    curi.setForceFetch(forceRevisit);
                    if (asSeeds) {
                        curi.setSeed(asSeeds);
                        if (curi.getVia() == null || curi.getVia().length() <= 0) {
                            this.getSeeds().addSeed(curi);
                        }
                    }
                    if (scope != null && !scope.accepts(curi)) continue;
                    this.controller.getFrontier().schedule(curi);
                }
                catch (URIException e) {
                    e.printStackTrace();
                }
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void log(CrawlURI curi) {
        curi.aboutToLog();
        Object[] array = new Object[]{curi};
        this.loggerModule.getUriProcessing().log(Level.INFO, curi.getUURI().toString(), array);
    }

    protected boolean isDisregarded(CrawlURI curi) {
        switch (curi.getFetchStatus()) {
            case -9998: 
            case -6000: 
            case -5002: 
            case -5001: 
            case -5000: 
            case -4002: 
            case -4001: {
                return true;
            }
        }
        return false;
    }

    public boolean needsReenqueuing(CrawlURI curi) {
        if (this.overMaxRetries(curi)) {
            return false;
        }
        switch (curi.getFetchStatus()) {
            case 401: {
                boolean loaded = curi.hasRfc2617Credential();
                if (!loaded && logger.isLoggable(Level.FINE)) {
                    logger.fine("Have 401 but no creds loaded " + curi);
                }
                return loaded;
            }
            case -50: 
            case -3: 
            case -2: 
            case -1: {
                return true;
            }
            case 0: {
                if (!curi.includesRetireDirective()) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public FrontierJournal getFrontierJournal() {
        return this.recover;
    }

    public void crawlEnded(String sExitMessage) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Closing with " + Long.toString(this.queuedUriCount()) + " urls still in queue.");
        }
    }

    public String shortReportLine() {
        return ReportUtils.shortReportLine((Reporter)this);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof CrawlStateEvent) {
            CrawlStateEvent event1 = (CrawlStateEvent)event;
            switch (event1.getState()) {
                case FINISHED: {
                    this.crawlEnded(event1.getMessage());
                    break;
                }
            }
        }
    }

    @Override
    public void beginDisposition(CrawlURI curi) {
        this.dispositionPending.set(curi);
        this.dispositionInProgressLock.readLock().lock();
    }

    @Override
    public void endDisposition() {
        if (this.dispositionPending.get() != null) {
            this.dispositionInProgressLock.readLock().unlock();
            this.dispositionPending.set(null);
        }
    }
}

