/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.management.openmbean.CompositeData;
import org.apache.commons.collections.Closure;
import org.apache.commons.io.IOUtils;
import org.archive.bdb.BdbModule;
import org.archive.bdb.DisposableStoredSortedMap;
import org.archive.bdb.StoredQueue;
import org.archive.checkpointing.Checkpoint;
import org.archive.checkpointing.Checkpointable;
import org.archive.crawler.framework.Frontier;
import org.archive.crawler.frontier.BdbMultipleWorkQueues;
import org.archive.crawler.frontier.BdbWorkQueue;
import org.archive.crawler.frontier.DelayedWorkQueue;
import org.archive.crawler.frontier.WorkQueue;
import org.archive.crawler.frontier.WorkQueueFrontier;
import org.archive.modules.CrawlURI;
import org.archive.util.ArchiveUtils;
import org.archive.util.ObjectIdentityCache;
import org.archive.util.Supplier;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;

public class BdbFrontier
extends WorkQueueFrontier
implements Checkpointable,
BeanNameAware {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(BdbFrontier.class.getName());
    protected SortedMap<Integer, Queue<String>> inactiveQueuesByPrecedence;
    protected StoredQueue<String> retiredQueues;
    protected transient BdbMultipleWorkQueues pendingUris;
    protected BdbModule bdb;
    protected String beanName;
    protected boolean dumpPendingAtClose = false;
    protected Checkpoint recoveryCheckpoint;

    @Autowired
    public void setBdbModule(BdbModule bdb) {
        this.bdb = bdb;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public boolean getDumpPendingAtClose() {
        return this.dumpPendingAtClose;
    }

    public void setDumpPendingAtClose(boolean dumpPendingAtClose) {
        this.dumpPendingAtClose = dumpPendingAtClose;
    }

    @Override
    protected SortedMap<Integer, Queue<String>> getInactiveQueuesByPrecedence() {
        return this.inactiveQueuesByPrecedence;
    }

    @Override
    protected Queue<String> getRetiredQueues() {
        return this.retiredQueues;
    }

    protected BdbMultipleWorkQueues createMultipleWorkQueues() throws DatabaseException {
        boolean recycle = this.recoveryCheckpoint != null;
        BdbModule.BdbConfig dbConfig = new BdbModule.BdbConfig();
        dbConfig.setAllowCreate(!recycle);
        Database db = this.bdb.openDatabase("pending", dbConfig, recycle);
        return new BdbMultipleWorkQueues(db, this.bdb.getClassCatalog());
    }

    @Override
    protected WorkQueue getQueueFor(final String classKey) {
        WorkQueue wq = (WorkQueue)this.allQueues.getOrUse(classKey, (Supplier)new Supplier<WorkQueue>(){

            public BdbWorkQueue get() {
                String qKey = new String(classKey);
                BdbWorkQueue q = new BdbWorkQueue(qKey, BdbFrontier.this);
                q.setTotalBudget(BdbFrontier.this.getQueueTotalBudget());
                BdbFrontier.this.getQueuePrecedencePolicy().queueCreated(q);
                return q;
            }
        });
        return wq;
    }

    @Override
    public Frontier.FrontierGroup getGroup(CrawlURI curi) {
        return this.getQueueFor(curi.getClassKey());
    }

    @Override
    public CompositeData getURIsList(String marker, int numberOfMatches, String pattern, boolean verbose) {
        try {
            Pattern p = Pattern.compile(pattern);
            return this.pendingUris.getFrom(marker, numberOfMatches, p, verbose);
        }
        catch (DatabaseException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected void finalTasks() {
        super.finalTasks();
        if (this.getDumpPendingAtClose()) {
            try {
                this.dumpAllPendingToLog();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "dump pending problem", e);
            }
        }
    }

    @Override
    public void close() {
        ArchiveUtils.closeQuietly((Object)this.pendingUris);
        super.close();
    }

    protected BdbMultipleWorkQueues getWorkQueues() {
        return this.pendingUris;
    }

    @Override
    protected boolean workQueueDataOnDisk() {
        return true;
    }

    public void startCheckpoint(Checkpoint checkpointInProgress) {
        this.dispositionInProgressLock.writeLock().lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCheckpoint(Checkpoint checkpointInProgress) {
        this.pendingUris.sync();
        JSONObject json = new JSONObject();
        try {
            json.put("nextOrdinal", this.nextOrdinal.get());
            json.put("queuedUriCount", this.queuedUriCount.get());
            json.put("futureUriCount", this.futureUriCount.get());
            json.put("succeededFetchCount", this.succeededFetchCount.get());
            json.put("failedFetchCount", this.failedFetchCount.get());
            json.put("disregardedUriCount", this.disregardedUriCount.get());
            json.put("totalProcessedBytes", this.totalProcessedBytes.get());
            json.put("inactivePrecedences", this.inactiveQueuesByPrecedence.keySet());
            checkpointInProgress.saveJson(this.beanName, json);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        PrintWriter activeQueuesWriter = null;
        try {
            activeQueuesWriter = new PrintWriter(checkpointInProgress.saveWriter(this.beanName, "active"));
            for (Delayed q : this.inProcessQueues) {
                activeQueuesWriter.println(((WorkQueue)q).getClassKey());
            }
            for (String qk : this.readyClassQueues) {
                activeQueuesWriter.println(qk);
            }
            for (Delayed q : this.snoozedClassQueues) {
                activeQueuesWriter.println(((DelayedWorkQueue)q).getClassKey());
            }
            for (Delayed q : this.snoozedOverflow.values()) {
                activeQueuesWriter.println(((DelayedWorkQueue)q).getClassKey());
            }
        }
        catch (IOException ioe) {
            try {
                checkpointInProgress.setSuccess(false);
                logger.log(Level.SEVERE, "problem writing checkpoint", ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(activeQueuesWriter);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)activeQueuesWriter);
        }
        IOUtils.closeQuietly((Writer)activeQueuesWriter);
        if (this.recover != null) {
            this.recover.rotateForCheckpoint(checkpointInProgress);
        }
    }

    public void finishCheckpoint(Checkpoint checkpointInProgress) {
        this.dispositionInProgressLock.writeLock().unlock();
    }

    @Autowired(required=false)
    public void setRecoveryCheckpoint(Checkpoint checkpoint) {
        this.recoveryCheckpoint = checkpoint;
    }

    @Override
    protected void initAllQueues() throws DatabaseException {
        boolean isRecovery = this.recoveryCheckpoint != null;
        this.allQueues = this.bdb.getObjectCache("allqueues", isRecovery, WorkQueue.class, BdbWorkQueue.class);
        if (isRecovery) {
            JSONObject json = this.recoveryCheckpoint.loadJson(this.beanName);
            try {
                this.nextOrdinal.set(json.getLong("nextOrdinal"));
                this.queuedUriCount.set(json.getLong("queuedUriCount"));
                this.futureUriCount.set(json.getLong("futureUriCount"));
                this.succeededFetchCount.set(json.getLong("succeededFetchCount"));
                this.failedFetchCount.set(json.getLong("failedFetchCount"));
                this.disregardedUriCount.set(json.getLong("disregardedUriCount"));
                this.totalProcessedBytes.set(json.getLong("totalProcessedBytes"));
                JSONArray inactivePrecedences = json.getJSONArray("inactivePrecedences");
                for (int i = 0; i < inactivePrecedences.length(); ++i) {
                    int precedence = inactivePrecedences.getInt(i);
                    this.inactiveQueuesByPrecedence.put(precedence, this.createInactiveQueueForPrecedence(precedence, true));
                }
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            BufferedReader activeQueuesReader = null;
            try {
                String line;
                activeQueuesReader = this.recoveryCheckpoint.loadReader(this.beanName, "active");
                while ((line = activeQueuesReader.readLine()) != null) {
                    this.readyClassQueues.add(line);
                }
            }
            catch (IOException ioe) {
                try {
                    throw new RuntimeException(ioe);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(activeQueuesReader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)activeQueuesReader);
        }
    }

    @Override
    protected void initOtherQueues() throws DatabaseException {
        boolean recycle = this.recoveryCheckpoint != null;
        this.readyClassQueues = new LinkedBlockingQueue();
        this.inactiveQueuesByPrecedence = new ConcurrentSkipListMap<Integer, Queue<String>>();
        this.retiredQueues = this.bdb.getStoredQueue("retiredQueues", String.class, recycle);
        this.snoozedClassQueues = new DelayQueue();
        this.snoozedOverflow = this.bdb.getStoredMap("snoozedOverflow", Long.class, DelayedWorkQueue.class, true, false);
        this.futureUris = this.bdb.getStoredMap("futureUris", Long.class, CrawlURI.class, true, this.recoveryCheckpoint != null);
        this.pendingUris = this.createMultipleWorkQueues();
    }

    @Override
    protected Queue<String> createInactiveQueueForPrecedence(int precedence) {
        return this.createInactiveQueueForPrecedence(precedence, false);
    }

    protected Queue<String> createInactiveQueueForPrecedence(int precedence, boolean usePriorData) {
        return this.bdb.getStoredQueue("inactiveQueues-" + precedence, String.class, usePriorData);
    }

    public void dumpAllPendingToLog() throws DatabaseException {
        Closure tolog = new Closure(){

            public void execute(Object curi) {
                BdbFrontier.this.log((CrawlURI)curi);
            }
        };
        this.forAllPendingDo(tolog);
    }

    public void forAllPendingDo(Closure closure) {
        this.pendingUris.forAllPendingDo(closure);
    }

    /*
     * WARNING - void declaration
     */
    public void consistencyCheck() {
        void var3_7;
        String summary;
        this.dispositionInProgressLock.writeLock().lock();
        System.err.println("<<<CHECKING FRONTIER CONSISTENCY");
        DisposableStoredSortedMap queueSummaries = this.bdb.getStoredMap(null, String.class, String.class, false, false);
        this.consistencyMarkup((DisposableStoredSortedMap<String, String>)queueSummaries, this.inProcessQueues, "i");
        this.consistencyMarkup((DisposableStoredSortedMap<String, String>)queueSummaries, this.readyClassQueues, "r");
        this.consistencyMarkup((DisposableStoredSortedMap<String, String>)queueSummaries, this.snoozedClassQueues, "s");
        this.consistencyMarkup((DisposableStoredSortedMap<String, String>)queueSummaries, this.snoozedOverflow.values(), "S");
        for (Map.Entry<Integer, Queue<String>> entry : this.getInactiveQueuesByPrecedence().entrySet()) {
            this.consistencyMarkup((DisposableStoredSortedMap<String, String>)queueSummaries, (Iterable)entry.getValue(), Integer.toString(entry.getKey()));
        }
        this.consistencyMarkup((DisposableStoredSortedMap<String, String>)queueSummaries, (Iterable<?>)this.retiredQueues, "R");
        int anomalies = 0;
        for (String q : this.allQueues.keySet()) {
            WorkQueue wq = (WorkQueue)this.allQueues.get(q);
            summary = (String)queueSummaries.get((Object)q);
            if (wq.getCount() > 0L && summary == null) {
                System.err.println("FRONTIER ANOMALY: " + q + " " + wq.getCount() + " " + wq.isManaged() + " but not in managed collections");
                ++anomalies;
            }
            if (wq.getCount() != 0L || summary != null || !wq.isManaged()) continue;
            System.err.println("FRONTIER ANOMALY: " + q + " " + wq.getCount() + " " + wq.isManaged() + " but not in managed collections");
            ++anomalies;
        }
        System.err.println(anomalies + " ANOMALIES");
        boolean bl = false;
        for (String q : queueSummaries.keySet()) {
            summary = (String)queueSummaries.get((Object)q);
            if (summary == null || summary.split(",").length <= 1) continue;
            WorkQueue wq = (WorkQueue)this.allQueues.get(q);
            System.err.println("FRONTIER CONCERN: " + q + " " + wq.getCount() + " multiple places: " + summary);
            System.err.println("\n" + wq.shortReportLegend() + "\n" + wq.shortReportLine());
            ++var3_7;
        }
        System.err.println((int)var3_7 + " CONCERNS");
        System.err.println("END CHECKING FRONTIER>>>");
        queueSummaries.dispose();
        this.dispositionInProgressLock.writeLock().unlock();
    }

    protected void consistencyMarkup(DisposableStoredSortedMap<String, String> queueSummaries, Iterable<?> queues, String mark) {
        for (Object qq : queues) {
            String key = qq instanceof String ? (String)qq : (qq instanceof WorkQueue ? ((WorkQueue)qq).getClassKey() : ((DelayedWorkQueue)qq).getClassKey());
            String val = (String)queueSummaries.get((Object)key);
            val = val == null ? mark : val + "," + mark;
            queueSummaries.put((Object)key, (Object)val);
        }
    }

    @Override
    public long exportPendingUris(PrintWriter writer) {
        if (this.pendingUris == null) {
            return -5L;
        }
        return this.pendingUris.exportPendingUris(writer);
    }

    @Override
    public ObjectIdentityCache<WorkQueue> getAllQueues() {
        return this.allQueues;
    }

    @Override
    public BlockingQueue<String> getReadyClassQueues() {
        return this.readyClassQueues;
    }

    @Override
    public Set<WorkQueue> getInProcessQueues() {
        return this.inProcessQueues;
    }
}

