/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier;

import org.archive.crawler.frontier.HostnameQueueAssignmentPolicy;
import org.archive.net.UURI;

public class HostnameQueueAssignmentPolicyWithLimits
extends HostnameQueueAssignmentPolicy {
    private static final long serialVersionUID = 3L;
    public static final String LIMIT = "limit";

    public HostnameQueueAssignmentPolicyWithLimits() {
        this.setLimit(-1);
    }

    public void setLimit(int limit) {
        this.kp.put((Object)LIMIT, (Object)limit);
    }

    public int getLimit() {
        return (Integer)this.kp.get(LIMIT);
    }

    @Override
    protected String getCoreKey(UURI basis) {
        int limit = (Integer)this.kp.get(LIMIT);
        return this.getLimitedHostname(super.getCoreKey(basis), limit);
    }

    protected String getLimitedHostname(String hostname, int limit) {
        if (limit <= 0) {
            return hostname;
        }
        String[] domains = hostname.split("\\.");
        if (limit >= domains.length) {
            return hostname;
        }
        StringBuilder limitedHostname = new StringBuilder();
        for (int i = domains.length - limit; i < domains.length - 1; ++i) {
            limitedHostname.append(domains[i]);
            limitedHostname.append(".");
        }
        limitedHostname.append(domains[domains.length - 1]);
        return limitedHostname.toString();
    }
}

