/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier;

import org.archive.crawler.frontier.SurtAuthorityQueueAssignmentPolicy;
import org.archive.net.UURI;

public class SurtAuthorityQueueAssignmentPolicyWithLimits
extends SurtAuthorityQueueAssignmentPolicy {
    private static final long serialVersionUID = 3L;
    public static final String LIMIT = "limit";

    public SurtAuthorityQueueAssignmentPolicyWithLimits() {
        this.setLimit(-1);
    }

    public void setLimit(int limit) {
        this.kp.put((Object)LIMIT, (Object)limit);
    }

    public int getLimit() {
        return (Integer)this.kp.get(LIMIT);
    }

    @Override
    protected String getCoreKey(UURI basis) {
        int limit = (Integer)this.kp.get(LIMIT);
        return this.getLimitedSurtAuthority(super.getCoreKey(basis), limit);
    }

    protected String getLimitedSurtAuthority(String surt, int limit) {
        String[] segments;
        if (limit <= 0) {
            return surt;
        }
        String domainPart = surt;
        String portPart = "";
        int indexOfHash = surt.indexOf(35);
        if (indexOfHash > -1) {
            domainPart = surt.substring(0, indexOfHash);
            portPart = surt.substring(indexOfHash);
        }
        if (limit >= (segments = domainPart.split(",")).length) {
            return surt;
        }
        StringBuilder limitedSurt = new StringBuilder();
        for (int i = 0; i < limit; ++i) {
            limitedSurt.append(segments[i]);
            limitedSurt.append(",");
        }
        limitedSurt.append(portPart);
        return limitedSurt.toString();
    }
}

