/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier;

import org.apache.commons.lang.StringUtils;
import org.archive.crawler.frontier.QueueAssignmentPolicy;
import org.archive.modules.CrawlURI;
import org.archive.net.UURI;
import org.archive.spring.HasKeyedProperties;
import org.archive.util.LongToIntConsistentHash;

public abstract class URIAuthorityBasedQueueAssignmentPolicy
extends QueueAssignmentPolicy
implements HasKeyedProperties {
    private static final long serialVersionUID = 3L;
    protected static String DEFAULT_CLASS_KEY = "default...";
    protected LongToIntConsistentHash conhash = new LongToIntConsistentHash();

    public URIAuthorityBasedQueueAssignmentPolicy() {
        this.setDeferToPrevious(true);
        this.setParallelQueues(1);
        this.setParallelQueuesRandomAssignment(false);
    }

    public boolean getDeferToPrevious() {
        return (Boolean)this.kp.get("deferToPrevious");
    }

    public void setDeferToPrevious(boolean defer) {
        this.kp.put((Object)"deferToPrevious", (Object)defer);
    }

    public int getParallelQueues() {
        return (Integer)this.kp.get("parallelQueues");
    }

    public void setParallelQueues(int count) {
        this.kp.put((Object)"parallelQueues", (Object)count);
    }

    public boolean getParallelQueuesRandomAssignment() {
        return (Boolean)this.kp.get("parallelQueuesRandomAssignment");
    }

    public void setParallelQueuesRandomAssignment(boolean doRandom) {
        this.kp.put((Object)"parallelQueuesRandomAssignment", (Object)doRandom);
    }

    @Override
    public String getClassKey(CrawlURI curi) {
        int subqueue;
        if (this.getDeferToPrevious() && !StringUtils.isEmpty((String)curi.getClassKey())) {
            return curi.getClassKey();
        }
        UURI basis = curi.getPolicyBasisUURI();
        String candidate = this.getCoreKey(basis);
        if (!StringUtils.isEmpty((String)this.getForceQueueAssignment())) {
            candidate = this.getForceQueueAssignment();
        }
        if (curi.getUURI().getScheme().equals("whois")) {
            return "whois...";
        }
        if (StringUtils.isEmpty((String)candidate)) {
            return DEFAULT_CLASS_KEY;
        }
        if (this.getParallelQueues() > 1 && (subqueue = this.getSubqueue(basis, this.getParallelQueues())) > 0) {
            candidate = candidate + "+" + subqueue;
        }
        return candidate;
    }

    protected int getSubqueue(UURI basisUuri, int parallelQueues) {
        String basis = this.bucketBasis(basisUuri);
        if (StringUtils.isEmpty((String)basis)) {
            return 0;
        }
        return this.conhash.bucketFor((CharSequence)basis, parallelQueues);
    }

    protected String bucketBasis(UURI uuri) {
        if (this.getParallelQueuesRandomAssignment()) {
            return uuri.getEscapedURI();
        }
        String path = new String(uuri.getRawPath());
        int i = path.indexOf(47, 1);
        if (i < 0) {
            return null;
        }
        return path.substring(1, i);
    }

    protected abstract String getCoreKey(UURI var1);
}

