/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier.precedence;

import java.io.PrintWriter;
import org.archive.crawler.frontier.WorkQueue;
import org.archive.crawler.frontier.precedence.BaseQueuePrecedencePolicy;
import org.archive.crawler.frontier.precedence.SimplePrecedenceProvider;
import org.archive.modules.CrawlURI;
import org.archive.modules.fetcher.FetchStats;
import org.archive.util.Histotable;

public class HighestUriQueuePrecedencePolicy
extends BaseQueuePrecedencePolicy {
    private static final long serialVersionUID = -8652293180921419601L;

    @Override
    protected void installProvider(WorkQueue wq) {
        HighestUriPrecedenceProvider provider = new HighestUriPrecedenceProvider(this.getBasePrecedence());
        wq.setPrecedenceProvider(provider);
    }

    public class HighestUriPrecedenceProvider
    extends SimplePrecedenceProvider {
        private static final long serialVersionUID = 5545297542888582745L;
        protected Histotable<Integer> enqueuedCounts;

        public HighestUriPrecedenceProvider(int base) {
            super(base);
            this.enqueuedCounts = new Histotable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void tally(CrawlURI curi, FetchStats.Stage stage) {
            switch (stage) {
                case SCHEDULED: {
                    Histotable<Integer> histotable = this.enqueuedCounts;
                    synchronized (histotable) {
                        this.enqueuedCounts.tally((Object)curi.getPrecedence());
                        break;
                    }
                }
                case SUCCEEDED: 
                case DISREGARDED: 
                case FAILED: {
                    Histotable<Integer> histotable = this.enqueuedCounts;
                    synchronized (histotable) {
                        this.enqueuedCounts.tally((Object)curi.getPrecedence(), -1L);
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getPrecedence() {
            Histotable<Integer> histotable = this.enqueuedCounts;
            synchronized (histotable) {
                Integer delta = this.enqueuedCounts.size() > 0 ? (Integer)this.enqueuedCounts.firstKey() : Integer.valueOf(0);
                return super.getPrecedence() + delta;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String shortReportLegend() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.shortReportLegend());
            sb.append(":");
            Histotable<Integer> histotable = this.enqueuedCounts;
            synchronized (histotable) {
                for (Integer p : this.enqueuedCounts.keySet()) {
                    sb.append(" p");
                    sb.append(p);
                }
            }
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shortReportLineTo(PrintWriter writer) {
            boolean betwixt = false;
            Histotable<Integer> histotable = this.enqueuedCounts;
            synchronized (histotable) {
                for (Long count : this.enqueuedCounts.values()) {
                    if (betwixt) {
                        writer.print(" ");
                    }
                    writer.print(count);
                    betwixt = true;
                }
            }
        }
    }
}

