/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier.precedence;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import java.util.Map;
import org.archive.bdb.BdbModule;
import org.archive.crawler.frontier.precedence.BaseUriPrecedencePolicy;
import org.archive.crawler.frontier.precedence.UriPrecedencePolicy;
import org.archive.modules.CrawlURI;
import org.archive.modules.recrawl.PersistProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.Lifecycle;

public class PreloadedUriPrecedencePolicy
extends BaseUriPrecedencePolicy
implements Lifecycle {
    private static final long serialVersionUID = -1474685153995064123L;
    protected BdbModule bdb;
    protected StoredSortedMap<String, ?> store;
    protected Database historyDb;

    public PreloadedUriPrecedencePolicy() {
        this.setDefaultUriPrecedencePolicy(new BaseUriPrecedencePolicy());
    }

    public UriPrecedencePolicy getDefaultUriPrecedencePolicy() {
        return (UriPrecedencePolicy)this.kp.get("defaultUriPrecedencePolicy");
    }

    public void setDefaultUriPrecedencePolicy(UriPrecedencePolicy policy) {
        this.kp.put((Object)"defaultUriPrecedencePolicy", (Object)policy);
    }

    @Autowired
    public void setBdbModule(BdbModule bdb) {
        this.bdb = bdb;
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.store = null;
        String dbName = "uri_history";
        try {
            StoredSortedMap historyMap;
            StoredClassCatalog classCatalog = this.bdb.getClassCatalog();
            BdbModule.BdbConfig dbConfig = PersistProcessor.HISTORY_DB_CONFIG;
            this.historyDb = this.bdb.openDatabase(dbName, dbConfig, true);
            SerialBinding sb = new SerialBinding((ClassCatalog)classCatalog, Map.class);
            this.store = historyMap = new StoredSortedMap(this.historyDb, (EntryBinding)new StringBinding(), (EntryBinding)sb, true);
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isRunning() {
        return this.historyDb != null;
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.historyDb = null;
    }

    @Override
    public void uriScheduled(CrawlURI curi) {
        int precedence = this.calculatePrecedence(curi);
        if (precedence == 0) {
            this.getDefaultUriPrecedencePolicy().uriScheduled(curi);
            return;
        }
        curi.setPrecedence(precedence);
    }

    @Override
    protected int calculatePrecedence(CrawlURI curi) {
        this.mergePrior(curi);
        Integer preloadPrecedence = (Integer)curi.getData().get("precalc-precedence");
        if (preloadPrecedence == null) {
            return 0;
        }
        return super.calculatePrecedence(curi) + preloadPrecedence;
    }

    protected void mergePrior(CrawlURI curi) {
        String key = PersistProcessor.persistKeyFor((CrawlURI)curi);
        Map prior = (Map)this.store.get((Object)key);
        if (prior != null) {
            curi.getData().putAll(prior);
        }
    }
}

