/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.monitor;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.crawler.event.StatSnapshotEvent;
import org.archive.crawler.framework.CrawlController;
import org.archive.spring.ConfigPathConfigurer;
import org.archive.util.ArchiveUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class DiskSpaceMonitor
implements ApplicationListener<ApplicationEvent> {
    private static final Logger logger = Logger.getLogger(DiskSpaceMonitor.class.getName());
    protected List<String> monitorPaths = new ArrayList<String>();
    protected long pauseThresholdMiB = 8192L;
    protected CrawlController controller;
    protected ConfigPathConfigurer configPathConfigurer;
    protected boolean monitorConfigPaths = true;

    public void setMonitorPaths(List<String> monitorPaths) {
        this.monitorPaths = monitorPaths;
    }

    public List<String> getMonitorPaths() {
        return this.monitorPaths;
    }

    public void setPauseThresholdMiB(long pauseThresholdMiB) {
        this.pauseThresholdMiB = pauseThresholdMiB;
    }

    public long getPauseThresholdMiB() {
        return this.pauseThresholdMiB;
    }

    public void setMonitorConfigPaths(boolean monitorConfigPaths) {
        this.monitorConfigPaths = monitorConfigPaths;
    }

    public boolean getMonitorConfigPaths() {
        return this.monitorConfigPaths;
    }

    @Autowired
    public void setCrawlController(CrawlController controller) {
        this.controller = controller;
    }

    public CrawlController getCrawlController() {
        return this.controller;
    }

    @Autowired
    public void setConfigPathConfigurer(ConfigPathConfigurer configPathConfigurer) {
        this.configPathConfigurer = configPathConfigurer;
    }

    public ConfigPathConfigurer getConfigPathConfigurer() {
        return this.configPathConfigurer;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof StatSnapshotEvent) {
            for (String path : this.getMonitorPaths()) {
                this.checkAvailableSpace(new File(path));
            }
            if (this.monitorConfigPaths) {
                for (String path : this.configPathConfigurer.getAllConfigPaths().values()) {
                    this.checkAvailableSpace(path.getFile());
                }
            }
        }
    }

    protected void checkAvailableSpace(File path) {
        long thresholdBytes;
        if (!path.exists()) {
            logger.fine("Ignoring non-existent path " + path.getAbsolutePath());
            return;
        }
        long availBytes = path.getUsableSpace();
        if (availBytes < (thresholdBytes = this.getPauseThresholdMiB() * 1024L * 1024L) && this.controller.isActive()) {
            this.controller.requestCrawlPause();
            String errorMsg = "Low Disk Pause - %d bytes (%s) available on %s, this is below the minimum threshold of %d bytes (%s)";
            logger.log(Level.SEVERE, String.format(errorMsg, availBytes, ArchiveUtils.formatBytesForDisplay((long)availBytes), path.getAbsolutePath(), thresholdBytes, ArchiveUtils.formatBytesForDisplay((long)thresholdBytes)));
        }
    }
}

