/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.postprocessor;

import org.apache.commons.httpclient.URIException;
import org.archive.crawler.framework.Frontier;
import org.archive.crawler.reporting.CrawlerLoggerModule;
import org.archive.crawler.spring.SheetOverlaysManager;
import org.archive.modules.CandidateChain;
import org.archive.modules.CrawlURI;
import org.archive.modules.Processor;
import org.archive.modules.extractor.Hop;
import org.archive.modules.seeds.SeedModule;
import org.archive.spring.KeyedProperties;
import org.archive.spring.OverlayContext;
import org.archive.util.ArchiveUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class CandidatesProcessor
extends Processor {
    private static final long serialVersionUID = -3L;
    protected CandidateChain candidateChain;
    protected Frontier frontier;
    protected CrawlerLoggerModule loggerModule;
    protected static final int SEEDS_REDIRECT_NEW_SEEDS_MAX_HOPS = 5;
    protected SeedModule seeds;
    protected SheetOverlaysManager sheetOverlaysManager;

    public CandidateChain getCandidateChain() {
        return this.candidateChain;
    }

    @Autowired
    public void setCandidateChain(CandidateChain candidateChain) {
        this.candidateChain = candidateChain;
    }

    public Frontier getFrontier() {
        return this.frontier;
    }

    @Autowired
    public void setFrontier(Frontier frontier) {
        this.frontier = frontier;
    }

    public CrawlerLoggerModule getLoggerModule() {
        return this.loggerModule;
    }

    @Autowired
    public void setLoggerModule(CrawlerLoggerModule loggerModule) {
        this.loggerModule = loggerModule;
    }

    public boolean getSeedsRedirectNewSeeds() {
        return (Boolean)this.kp.get("seedsRedirectNewSeeds");
    }

    public void setSeedsRedirectNewSeeds(boolean redirect) {
        this.kp.put((Object)"seedsRedirectNewSeeds", (Object)redirect);
    }

    public boolean getSeedsRedirectNewSeedsAllowTLDs() {
        return (Boolean)this.kp.get("seedsRedirectNewSeedsAllowTLDs");
    }

    public void setSeedsRedirectNewSeedsAllowTLDs(boolean allowTLDs) {
        this.kp.put((Object)"seedsRedirectNewSeedsAllowTLDs", (Object)allowTLDs);
    }

    public boolean getProcessErrorOutlinks() {
        return (Boolean)this.kp.get("processErrorOutlinks");
    }

    public void setProcessErrorOutlinks(boolean errorOutlinks) {
        this.kp.put((Object)"processErrorOutlinks", (Object)errorOutlinks);
    }

    public SeedModule getSeeds() {
        return this.seeds;
    }

    @Autowired
    public void setSeeds(SeedModule seeds) {
        this.seeds = seeds;
    }

    public SheetOverlaysManager getSheetOverlaysManager() {
        return this.sheetOverlaysManager;
    }

    @Autowired
    public void setSheetOverlaysManager(SheetOverlaysManager sheetOverlaysManager) {
        this.sheetOverlaysManager = sheetOverlaysManager;
    }

    public CandidatesProcessor() {
        this.setSeedsRedirectNewSeeds(true);
        this.setSeedsRedirectNewSeedsAllowTLDs(true);
        this.setProcessErrorOutlinks(false);
    }

    protected boolean shouldProcess(CrawlURI puri) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runCandidateChain(CrawlURI candidate, CrawlURI source) throws InterruptedException {
        candidate.setFullVia(source);
        this.sheetOverlaysManager.applyOverlaysTo(candidate);
        try {
            KeyedProperties.clearOverridesFrom((OverlayContext)source);
            KeyedProperties.loadOverridesFrom((OverlayContext)candidate);
            if (this.getSeedsRedirectNewSeeds() && source != null && source.isSeed() && candidate.getLastHop().equals(Hop.REFER.getHopString()) && candidate.getHopCount() < 5 && (this.getSeedsRedirectNewSeedsAllowTLDs() || this.domainIsNotTLD(candidate))) {
                candidate.setSeed(true);
            }
            this.getCandidateChain().process(candidate, null);
            int statusAfterCandidateChain = candidate.getFetchStatus();
            if (statusAfterCandidateChain >= 0) {
                if (this.checkForSeedPromotion(candidate)) {
                    candidate.setForceFetch(true);
                    this.getSeeds().addSeed(candidate);
                } else {
                    this.frontier.schedule(candidate);
                }
            }
            int n = statusAfterCandidateChain;
            return n;
        }
        finally {
            KeyedProperties.clearOverridesFrom((OverlayContext)candidate);
            KeyedProperties.loadOverridesFrom((OverlayContext)source);
        }
    }

    private boolean domainIsNotTLD(CrawlURI candidate) {
        try {
            return !ArchiveUtils.isTld((String)candidate.getBaseURI().getHost());
        }
        catch (URIException uRIException) {
            return false;
        }
    }

    protected void innerProcess(CrawlURI curi) throws InterruptedException {
        if (curi.hasPrerequisiteUri() && curi.getFetchStatus() == -50) {
            CrawlURI prereq = curi.getPrerequisiteUri();
            int prereqStatus = this.runCandidateChain(prereq, curi);
            if (prereqStatus < 0) {
                curi.setFetchStatus(-63);
            }
            return;
        }
        if (!(this.getProcessErrorOutlinks() || curi.getFetchStatus() >= 200 && curi.getFetchStatus() < 400)) {
            curi.getOutLinks().clear();
            return;
        }
        for (CrawlURI candidate : curi.getOutLinks()) {
            this.runCandidateChain(candidate, curi);
        }
    }

    protected boolean checkForSeedPromotion(CrawlURI curi) {
        if (curi.isSeed() && curi.getVia() != null && curi.flattenVia().length() > 0) {
            if (curi.getSchedulingDirective() == 3) {
                curi.setSchedulingDirective(2);
            }
            return true;
        }
        return false;
    }
}

