/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.postprocessor;

import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.httpclient.URIException;
import org.archive.modules.CrawlMetadata;
import org.archive.modules.CrawlURI;
import org.archive.modules.Processor;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.CrawlServer;
import org.archive.modules.net.IgnoreRobotsPolicy;
import org.archive.modules.net.Robotstxt;
import org.archive.modules.net.ServerCache;
import org.springframework.beans.factory.annotation.Autowired;

public class DispositionProcessor
extends Processor {
    private static final long serialVersionUID = -1072728147960180091L;
    private static final Logger logger = Logger.getLogger(DispositionProcessor.class.getName());
    protected ServerCache serverCache;
    protected CrawlMetadata metadata;

    public ServerCache getServerCache() {
        return this.serverCache;
    }

    @Autowired
    public void setServerCache(ServerCache serverCache) {
        this.serverCache = serverCache;
    }

    public float getDelayFactor() {
        return ((Float)this.kp.get("delayFactor")).floatValue();
    }

    public void setDelayFactor(float factor) {
        this.kp.put((Object)"delayFactor", (Object)Float.valueOf(factor));
    }

    public int getMinDelayMs() {
        return (Integer)this.kp.get("minDelayMs");
    }

    public void setMinDelayMs(int minDelay) {
        this.kp.put((Object)"minDelayMs", (Object)minDelay);
    }

    public int getRespectCrawlDelayUpToSeconds() {
        return (Integer)this.kp.get("respectCrawlDelayUpToSeconds");
    }

    public void setRespectCrawlDelayUpToSeconds(int respect) {
        this.kp.put((Object)"respectCrawlDelayUpToSeconds", (Object)respect);
    }

    public int getMaxDelayMs() {
        return (Integer)this.kp.get("maxDelayMs");
    }

    public void setMaxDelayMs(int maxDelay) {
        this.kp.put((Object)"maxDelayMs", (Object)maxDelay);
    }

    public int getMaxPerHostBandwidthUsageKbSec() {
        return (Integer)this.kp.get("maxPerHostBandwidthUsageKbSec");
    }

    public void setMaxPerHostBandwidthUsageKbSec(int max) {
        this.kp.put((Object)"maxPerHostBandwidthUsageKbSec", (Object)max);
    }

    public boolean getForceRetire() {
        return (Boolean)this.kp.get("forceRetire");
    }

    public void setForceRetire(boolean force) {
        this.kp.put((Object)"forceRetire", (Object)force);
    }

    public CrawlMetadata getMetadata() {
        return this.metadata;
    }

    @Autowired
    public void setMetadata(CrawlMetadata provider) {
        this.metadata = provider;
    }

    public DispositionProcessor() {
        this.setDelayFactor(5.0f);
        this.setMinDelayMs(3000);
        this.setRespectCrawlDelayUpToSeconds(300);
        this.setMaxDelayMs(30000);
        this.setMaxPerHostBandwidthUsageKbSec(0);
        this.setForceRetire(false);
    }

    protected boolean shouldProcess(CrawlURI puri) {
        return true;
    }

    protected void innerProcess(CrawlURI curi) {
        CrawlServer server = this.serverCache.getServerFor(curi.getUURI());
        String scheme = curi.getUURI().getScheme().toLowerCase();
        if (scheme.equals("http") || scheme.equals("https") && server != null) {
            if (curi.getFetchStatus() == -2 || curi.getFetchStatus() == -3) {
                server.incrementConsecutiveConnectionErrors();
            } else if (curi.getFetchStatus() > 0) {
                server.resetConsecutiveConnectionErrors();
            }
            try {
                if ("/robots.txt".equals(curi.getUURI().getPath()) && curi.getFetchStatus() != -50) {
                    if (this.metadata.getRobotsPolicy() instanceof IgnoreRobotsPolicy && curi.getFetchStatus() < 0 && curi.getFetchStatus() != -50) {
                        curi.setFetchStatus(-404);
                    }
                    server.updateRobots(curi);
                }
            }
            catch (URIException e) {
                logger.severe("Failed get path on " + curi.getUURI());
            }
        }
        curi.setPolitenessDelay(this.politenessDelayFor(curi));
        if (this.getForceRetire()) {
            curi.setForceRetire(true);
        }
    }

    protected long politenessDelayFor(CrawlURI curi) {
        long durationToWait = 0L;
        Map cdata = curi.getData();
        if (cdata.containsKey("fetch-began-time") && cdata.containsKey("fetch-completed-time")) {
            long respectThreshold;
            long maxDelay;
            long completeTime = curi.getFetchCompletedTime();
            long durationTaken = completeTime - curi.getFetchBeginTime();
            durationToWait = (long)(this.getDelayFactor() * (float)durationTaken);
            long minDelay = this.getMinDelayMs();
            if (minDelay > durationToWait) {
                durationToWait = minDelay;
            }
            if (durationToWait > (maxDelay = (long)this.getMaxDelayMs())) {
                durationToWait = maxDelay;
            }
            if (durationToWait < (respectThreshold = (long)(this.getRespectCrawlDelayUpToSeconds() * 1000))) {
                Robotstxt rep;
                CrawlServer s = this.getServerCache().getServerFor(curi.getUURI());
                String ua = curi.getUserAgent();
                if (ua == null) {
                    ua = this.metadata.getUserAgent();
                }
                if ((rep = s.getRobotstxt()) != null) {
                    long crawlDelay = (long)(1000.0f * rep.getDirectivesFor(ua).getCrawlDelay());
                    long l = crawlDelay = crawlDelay > respectThreshold ? respectThreshold : crawlDelay;
                    if (crawlDelay > durationToWait) {
                        durationToWait = crawlDelay;
                    }
                }
            }
            long now = System.currentTimeMillis();
            int maxBandwidthKB = this.getMaxPerHostBandwidthUsageKbSec();
            if (maxBandwidthKB > 0) {
                ServerCache cache = this.getServerCache();
                CrawlHost host = cache.getHostFor(curi.getUURI());
                long minDurationToWait = host.getEarliestNextURIEmitTime() - now;
                float maxBandwidth = (float)maxBandwidthKB * 1.024f;
                long processedBytes = curi.getContentSize();
                host.setEarliestNextURIEmitTime((long)((float)processedBytes / maxBandwidth) + now);
                if (minDurationToWait > durationToWait) {
                    durationToWait = minDurationToWait;
                }
            }
        }
        return durationToWait;
    }
}

