/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.postprocessor;

import org.archive.modules.CrawlURI;
import org.archive.modules.Processor;

public class ReschedulingProcessor
extends Processor {
    public long getRescheduleDelaySeconds() {
        return (Long)this.kp.get("rescheduleDelaySeconds");
    }

    public void setRescheduleDelaySeconds(long rescheduleDelaySeconds) {
        this.kp.put((Object)"rescheduleDelaySeconds", (Object)rescheduleDelaySeconds);
    }

    public ReschedulingProcessor() {
        this.setRescheduleDelaySeconds(-1L);
    }

    protected boolean shouldProcess(CrawlURI curi) {
        return true;
    }

    protected void innerProcess(CrawlURI curi) {
        if (curi.isPrerequisite()) {
            curi.setRescheduleTime(-1L);
            return;
        }
        long rds = this.getRescheduleDelaySeconds();
        if (rds > 0L) {
            curi.setRescheduleTime(System.currentTimeMillis() + 1000L * rds);
        } else {
            curi.setRescheduleTime(-1L);
        }
    }
}

