/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.postprocessor;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.crawler.framework.Scoper;
import org.archive.modules.CrawlURI;
import org.archive.modules.deciderules.AcceptDecideRule;
import org.archive.modules.deciderules.DecideResult;
import org.archive.modules.deciderules.DecideRule;

public class SupplementaryLinksScoper
extends Scoper {
    private static final long serialVersionUID = -3L;
    private static Logger LOGGER = Logger.getLogger(SupplementaryLinksScoper.class.getName());

    public DecideRule getSupplementaryRule() {
        return (DecideRule)this.kp.get("supplementaryRule");
    }

    public void setSupplementaryRule(DecideRule rule) {
        this.kp.put((Object)"supplementaryRule", (Object)rule);
    }

    public SupplementaryLinksScoper() {
        this.setSupplementaryRule((DecideRule)new AcceptDecideRule());
    }

    protected boolean shouldProcess(CrawlURI puri) {
        return puri instanceof CrawlURI;
    }

    protected void innerProcess(CrawlURI puri) {
        CrawlURI curi = puri;
        if (curi.hasPrerequisiteUri() || curi.getOutLinks().isEmpty()) {
            return;
        }
        Iterator iter = curi.getOutLinks().iterator();
        while (iter.hasNext()) {
            CrawlURI cauri = (CrawlURI)iter.next();
            if (this.isInScope(cauri)) continue;
            iter.remove();
        }
    }

    @Override
    protected boolean isInScope(CrawlURI caUri) {
        CrawlURI curi = caUri instanceof CrawlURI ? caUri : new CrawlURI(caUri.getUURI());
        boolean result = false;
        DecideRule seq = this.getSupplementaryRule();
        if (seq.decisionFor(curi) == DecideResult.ACCEPT) {
            result = true;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Accepted: " + caUri);
            }
        } else {
            this.outOfScope(caUri);
        }
        return result;
    }

    @Override
    protected void outOfScope(CrawlURI caUri) {
        if (!LOGGER.isLoggable(Level.INFO)) {
            return;
        }
        LOGGER.info(caUri.getUURI().toString());
    }
}

