/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.processor;

import java.util.regex.Matcher;
import org.archive.crawler.framework.Frontier;
import org.archive.crawler.processor.CrawlMapper;
import org.archive.modules.CrawlURI;
import org.archive.net.PublicSuffixes;
import org.archive.util.TextUtils;
import org.springframework.beans.factory.annotation.Autowired;
import st.ata.util.FPGenerator;

public class HashCrawlMapper
extends CrawlMapper {
    private static final long serialVersionUID = 2L;
    protected Frontier frontier;
    protected long crawlerCount = 1L;

    public Frontier getFrontier() {
        return this.frontier;
    }

    @Autowired
    public void setFrontier(Frontier frontier) {
        this.frontier = frontier;
    }

    public long getCrawlerCount() {
        return this.crawlerCount;
    }

    public void setCrawlerCount(long count) {
        this.crawlerCount = count;
    }

    public boolean getUsePublicSuffixesRegex() {
        return (Boolean)this.kp.get("usePublicSuffixesRegex");
    }

    public void setUsePublicSuffixesRegex(boolean usePublicSuffixes) {
        this.kp.put((Object)"usePublicSuffixesRegex", (Object)usePublicSuffixes);
    }

    public String getReducePrefixRegex() {
        return (String)this.kp.get("reducePrefixRegex");
    }

    public void setReducePrefixRegex(String regex) {
        this.kp.put((Object)"reducePrefixRegex", (Object)regex);
    }

    public HashCrawlMapper() {
        this.setUsePublicSuffixesRegex(true);
        this.setReducePrefixRegex("");
    }

    @Override
    protected String map(CrawlURI cauri) {
        String key = this.frontier.getClassKey(cauri);
        String reduceRegex = this.getReduceRegex(cauri);
        return HashCrawlMapper.mapString(key, reduceRegex, this.getCrawlerCount());
    }

    protected String getReduceRegex(CrawlURI cauri) {
        if (this.getUsePublicSuffixesRegex()) {
            return PublicSuffixes.getTopmostAssignedSurtPrefixRegex();
        }
        return this.getReducePrefixRegex();
    }

    public static String mapString(String key, String reducePattern, long bucketCount) {
        long fp;
        long bucket;
        if (reducePattern != null && reducePattern.length() > 0) {
            Matcher matcher = TextUtils.getMatcher((String)reducePattern, (CharSequence)key);
            if (matcher.find()) {
                key = matcher.group();
            }
            TextUtils.recycleMatcher((Matcher)matcher);
        }
        return Long.toString((bucket = (fp = FPGenerator.std64.fp((CharSequence)key)) % bucketCount) >= 0L ? bucket : -bucket);
    }
}

