/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.processor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.archive.crawler.framework.Frontier;
import org.archive.crawler.processor.CrawlMapper;
import org.archive.modules.CrawlURI;
import org.archive.spring.ConfigPath;
import org.archive.util.iterator.LineReadingIterator;
import org.archive.util.iterator.RegexLineIterator;
import org.springframework.beans.factory.annotation.Autowired;

public class LexicalCrawlMapper
extends CrawlMapper {
    private static final long serialVersionUID = 2L;
    protected ConfigPath mapPath = new ConfigPath("map specification file", "lexicalcrawlmapper.config");
    protected String mapUri = "";
    protected Frontier frontier;
    protected TreeMap<String, String> map = new TreeMap();

    public ConfigPath getMapPath() {
        return this.mapPath;
    }

    public void setMapPath(ConfigPath path) {
        this.mapPath = path;
    }

    public String getMapUri() {
        return this.mapUri;
    }

    public void setMapUri(String uri) {
        this.mapUri = uri;
    }

    public Frontier getFrontier() {
        return this.frontier;
    }

    @Autowired
    public void setFrontier(Frontier frontier) {
        this.frontier = frontier;
    }

    @Override
    protected String map(CrawlURI cauri) {
        String classKey = this.frontier.getClassKey(cauri);
        SortedMap<String, String> tail = this.map.tailMap(classKey);
        if (tail.isEmpty()) {
            tail = this.map;
        }
        return (String)tail.get(tail.firstKey());
    }

    @Override
    public void start() {
        super.start();
        try {
            this.loadMap();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected void loadMap() throws IOException {
        this.map.clear();
        String uri = this.getMapUri();
        Reader reader = null;
        if (uri.trim().length() == 0) {
            File source = this.getMapPath().getFile();
            reader = new FileReader(source);
        } else {
            URLConnection conn = new URL(uri).openConnection();
            reader = new InputStreamReader(conn.getInputStream());
        }
        reader = new BufferedReader(reader);
        RegexLineIterator iter = new RegexLineIterator((Iterator)new LineReadingIterator((BufferedReader)reader), "\\s*(#.*)?", "^\\s*([^#]+?)\\s*(#.*)?$", "$1");
        while (iter.hasNext()) {
            String[] entry = ((String)iter.next()).split("\\s+");
            this.map.put(entry[0], entry[1]);
        }
        reader.close();
    }
}

