/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.reporting;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.archive.io.SinkHandlerLogThread;

public class AlertThreadGroup
extends ThreadGroup {
    protected int count;
    protected LinkedList<Logger> loggers = new LinkedList();
    protected static ThreadLocal<Logger> threadLogger = new ThreadLocal();

    public AlertThreadGroup(String name) {
        super(name);
    }

    public int getAlertCount() {
        return this.count;
    }

    public void resetAlertCount() {
        this.count = 0;
    }

    public void addLogger(Logger logger) {
        this.loggers.add(logger);
    }

    public static void setThreadLogger(Logger logger) {
        threadLogger.set(logger);
    }

    public static AlertThreadGroup current() {
        ThreadGroup th;
        Thread t = Thread.currentThread();
        for (th = t.getThreadGroup(); th != null && !(th instanceof AlertThreadGroup); th = th.getParent()) {
        }
        return (AlertThreadGroup)th;
    }

    public static void publishCurrent(LogRecord record) {
        AlertThreadGroup atg = AlertThreadGroup.current();
        if (atg == null) {
            Logger tlog = threadLogger.get();
            if (tlog != null) {
                boolean usePar = tlog.getUseParentHandlers();
                tlog.setUseParentHandlers(false);
                tlog.log(record);
                tlog.setUseParentHandlers(usePar);
            }
            return;
        }
        atg.publish(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(LogRecord record) {
        SinkHandlerLogThread tt;
        String orig = record.getMessage();
        StringBuilder newMessage = new StringBuilder(256);
        Thread current = Thread.currentThread();
        newMessage.append(orig).append(" (in thread '");
        newMessage.append(current.getName()).append("'");
        if (current instanceof SinkHandlerLogThread && (tt = (SinkHandlerLogThread)current).getCurrentProcessorName().length() > 0) {
            newMessage.append("; in processor '");
            newMessage.append(tt.getCurrentProcessorName());
            newMessage.append("'");
        }
        newMessage.append(")");
        record.setMessage(newMessage.toString());
        ++this.count;
        Iterator iterator = this.loggers.iterator();
        while (iterator.hasNext()) {
            Logger logger;
            Logger logger2 = logger = (Logger)iterator.next();
            synchronized (logger2) {
                boolean usePar = logger.getUseParentHandlers();
                logger.setUseParentHandlers(false);
                logger.log(record);
                logger.setUseParentHandlers(usePar);
            }
        }
    }
}

