/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.reporting;

import org.archive.crawler.framework.CrawlController;
import org.archive.crawler.reporting.StatisticsTracker;
import org.archive.util.ArchiveUtils;
import org.archive.util.PaddingStringBuffer;

public class CrawlStatSnapshot {
    public long timestamp;
    public long urisFetched;
    public long bytesProcessed;
    public long discoveredUriCount;
    public long queuedUriCount;
    public long futureUriCount;
    public long finishedUriCount;
    public long downloadedUriCount;
    public long downloadFailures;
    public long downloadDisregards;
    public long elapsedMilliseconds;
    public double docsPerSecond;
    public double currentDocsPerSecond;
    public long totalKiBPerSec;
    public long currentKiBPerSec;
    public int busyThreads;
    public float congestionRatio;
    public long deepestUri;
    public long averageDepth;
    public long novelBytes;
    public long novelUriCount;
    public long warcNovelBytes;
    public long warcNovelUriCount;

    public void collect(CrawlController controller, StatisticsTracker stats) {
        this.downloadedUriCount = controller.getFrontier().succeededFetchCount();
        this.bytesProcessed = stats.crawledBytes.getTotalBytes();
        this.timestamp = System.currentTimeMillis();
        this.novelBytes = stats.crawledBytes.get((Object)"novel");
        this.novelUriCount = stats.crawledBytes.get((Object)"novelCount");
        this.warcNovelBytes = stats.crawledBytes.get((Object)"warcNovelContentBytes");
        this.warcNovelUriCount = stats.crawledBytes.get((Object)"warcNovelUrls");
        this.elapsedMilliseconds = stats.getCrawlElapsedTime();
        this.discoveredUriCount = controller.getFrontier().discoveredUriCount();
        this.finishedUriCount = controller.getFrontier().finishedUriCount();
        this.queuedUriCount = controller.getFrontier().queuedUriCount();
        this.futureUriCount = controller.getFrontier().futureUriCount();
        this.downloadFailures = controller.getFrontier().failedFetchCount();
        this.downloadDisregards = controller.getFrontier().disregardedUriCount();
        this.busyThreads = controller.getActiveToeCount();
        this.congestionRatio = controller.getFrontier().congestionRatio();
        this.deepestUri = controller.getFrontier().deepestUri();
        this.averageDepth = controller.getFrontier().averageDepth();
        this.docsPerSecond = (double)this.downloadedUriCount / ((double)stats.getCrawlElapsedTime() / 1000.0);
        this.totalKiBPerSec = (long)((double)this.bytesProcessed / 1024.0 / ((double)(stats.getCrawlElapsedTime() + 1L) / 1000.0));
        CrawlStatSnapshot lastSnapshot = stats.snapshots.peek();
        if (lastSnapshot == null) {
            return;
        }
        long sampleTime = this.timestamp - lastSnapshot.timestamp;
        this.currentDocsPerSecond = (double)(this.downloadedUriCount - lastSnapshot.downloadedUriCount) / ((double)sampleTime / 1000.0);
        this.currentKiBPerSec = (long)((double)((this.bytesProcessed - lastSnapshot.bytesProcessed) / 1024L) / ((double)sampleTime / 1000.0));
    }

    public String getProgressStatisticsLine() {
        return new PaddingStringBuffer().append(ArchiveUtils.getLog14Date((long)this.timestamp)).raAppend(32, this.discoveredUriCount).raAppend(44, this.queuedUriCount).raAppend(57, this.downloadedUriCount).raAppend(74, ArchiveUtils.doubleToString((double)this.currentDocsPerSecond, (int)2) + "(" + ArchiveUtils.doubleToString((double)this.docsPerSecond, (int)2) + ")").raAppend(85, this.currentKiBPerSec + "(" + this.totalKiBPerSec + ")").raAppend(99, this.downloadFailures).raAppend(113, this.busyThreads).raAppend(126, (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L).raAppend(140, Runtime.getRuntime().totalMemory() / 1024L).raAppend(153, ArchiveUtils.doubleToString((double)this.congestionRatio, (int)2)).raAppend(165, this.deepestUri).raAppend(177, this.averageDepth).toString();
    }

    public long totalCount() {
        return this.queuedUriCount + (long)this.busyThreads + this.downloadedUriCount;
    }

    public int percentOfDiscoveredUrisCompleted() {
        long total = this.discoveredUriCount;
        if (total == 0L) {
            return 0;
        }
        return (int)(100L * this.finishedUriCount / total);
    }

    public boolean sameProgressAs(CrawlStatSnapshot lastSnapshot) {
        if (lastSnapshot == null) {
            return false;
        }
        return this.finishedUriCount == lastSnapshot.finishedUriCount && this.queuedUriCount == lastSnapshot.queuedUriCount && this.downloadDisregards == lastSnapshot.downloadDisregards;
    }
}

