/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.reporting;

import java.io.IOException;
import java.io.PrintWriter;
import org.archive.crawler.frontier.WorkQueueFrontier;
import org.archive.crawler.reporting.Report;
import org.archive.crawler.reporting.StatisticsTracker;

public class FrontierNonemptyReport
extends Report {
    @Override
    public void write(PrintWriter writer, StatisticsTracker stats) {
        if (!stats.controller.getFrontier().isRunning()) {
            writer.println("frontier unstarted");
        } else if (stats.controller.getFrontier().isEmpty()) {
            writer.println("frontier empty");
        } else if (stats.controller.getFrontier() instanceof WorkQueueFrontier) {
            ((WorkQueueFrontier)stats.controller.getFrontier()).allNonemptyReportTo(writer);
        } else {
            try {
                stats.controller.getFrontier().reportTo(writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getFilename() {
        return "frontier-nonempty-report.txt";
    }
}

