/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.reporting;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.bdb.DisposableStoredSortedMap;
import org.archive.crawler.reporting.Report;
import org.archive.crawler.reporting.StatisticsTracker;
import org.archive.modules.net.CrawlHost;

public class HostsReport
extends Report {
    private static final Logger logger = Logger.getLogger(HostsReport.class.getName());
    int maxSortSize = -1;
    boolean suppressEmptyHosts = false;

    public int getMaxSortSize() {
        return this.maxSortSize;
    }

    public void setMaxSortSize(int maxSortSize) {
        this.maxSortSize = maxSortSize;
    }

    public boolean isSuppressEmptyHosts() {
        return this.suppressEmptyHosts;
    }

    public void setSuppressEmptyHosts(boolean suppressEmptyHosts) {
        this.suppressEmptyHosts = suppressEmptyHosts;
    }

    @Override
    public void write(PrintWriter writer, StatisticsTracker stats) {
        Collection keys = null;
        DisposableStoredSortedMap<Long, String> hd = null;
        if (this.maxSortSize < 0 || this.maxSortSize > stats.serverCache.hostKeys().size()) {
            hd = stats.calcReverseSortedHostsDistribution();
            keys = hd.values();
        } else {
            keys = stats.serverCache.hostKeys();
        }
        writer.print("[#urls] [#bytes] [host] [#robots] [#remaining] [#novel-urls] [#novel-bytes] [#dup-by-hash-urls] [#dup-by-hash-bytes] [#not-modified-urls] [#not-modified-bytes]\n");
        for (String key : keys) {
            try {
                CrawlHost host = stats.serverCache.getHostFor(key);
                long fetchSuccesses = host.getSubstats().getFetchSuccesses();
                if (this.suppressEmptyHosts && fetchSuccesses <= 0L) continue;
                this.writeReportLine(writer, fetchSuccesses, host.getSubstats().getTotalBytes(), host.fixUpName(), host.getSubstats().getRobotsDenials(), host.getSubstats().getRemaining(), host.getSubstats().getNovelUrls(), host.getSubstats().getNovelBytes(), host.getSubstats().getDupByHashUrls(), host.getSubstats().getDupByHashBytes(), host.getSubstats().getNotModifiedUrls(), host.getSubstats().getNotModifiedBytes());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "unable to tally host stats for " + key, e);
            }
        }
        if (hd != null) {
            hd.dispose();
        }
    }

    protected void writeReportLine(PrintWriter writer, Object ... fields) {
        for (Object field : fields) {
            writer.print(field);
            writer.print(" ");
        }
        writer.print("\n");
    }

    @Override
    public String getFilename() {
        return "hosts-report.txt";
    }
}

