/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.reporting;

import java.io.PrintWriter;
import java.util.Map;
import org.archive.bdb.DisposableStoredSortedMap;
import org.archive.crawler.reporting.Report;
import org.archive.crawler.reporting.StatisticsTracker;

public class MimetypesReport
extends Report {
    @Override
    public void write(PrintWriter writer, StatisticsTracker stats) {
        writer.print("[#urls] [#bytes] [mime-types]\n");
        DisposableStoredSortedMap<Long, String> fd = stats.getReverseSortedCopy(stats.getFileDistribution());
        for (Map.Entry entry : fd.entrySet()) {
            writer.print(Math.abs((Long)entry.getKey()));
            writer.print(" ");
            writer.print(stats.getBytesPerFileType((String)entry.getValue()));
            writer.print(" ");
            writer.print((String)entry.getValue());
            writer.print("\n");
        }
        fd.dispose();
    }

    @Override
    public String getFilename() {
        return "mimetype-report.txt";
    }
}

