/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.reporting;

import java.io.PrintWriter;
import java.util.Map;
import org.archive.bdb.DisposableStoredSortedMap;
import org.archive.crawler.reporting.Report;
import org.archive.crawler.reporting.StatisticsTracker;

public class ResponseCodeReport
extends Report {
    @Override
    public void write(PrintWriter writer, StatisticsTracker stats) {
        writer.print("[#urls] [rescode]\n");
        DisposableStoredSortedMap<Long, String> scd = stats.getReverseSortedCopy(stats.getStatusCodeDistribution());
        for (Map.Entry entry : scd.entrySet()) {
            writer.print(Math.abs((Long)entry.getKey()));
            writer.print(" ");
            writer.print((String)entry.getValue());
            writer.print("\n");
        }
        scd.dispose();
    }

    @Override
    public String getFilename() {
        return "responsecode-report.txt";
    }
}

