/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.reporting;

import java.io.Serializable;
import java.util.logging.Logger;
import org.archive.modules.CoreAttributeConstants;
import org.archive.modules.CrawlURI;
import org.archive.util.IdentityCacheable;
import org.archive.util.ObjectIdentityCache;

public class SeedRecord
implements CoreAttributeConstants,
Serializable,
IdentityCacheable {
    private static final long serialVersionUID = -8455358640509744478L;
    private static Logger logger = Logger.getLogger(SeedRecord.class.getName());
    private final String uri;
    private int statusCode;
    private String disposition;
    private String redirectUri;
    private transient ObjectIdentityCache<?> cache;

    public SeedRecord(CrawlURI curi, String disposition) {
        this.uri = curi.getURI();
        this.fillWith(curi, disposition);
    }

    public SeedRecord(String uri, String disposition) {
        this(uri, disposition, -1, null);
    }

    public SeedRecord(String uri, String disposition, int statusCode, String redirectUri) {
        this.uri = uri;
        this.statusCode = statusCode;
        this.disposition = disposition;
        this.redirectUri = redirectUri;
    }

    public void updateWith(CrawlURI curi, String disposition) {
        this.fillWith(curi, disposition);
        this.makeDirty();
    }

    protected void fillWith(CrawlURI curi, String disposition) {
        if (!this.uri.equals(curi.getURI())) {
            logger.warning("SeedRecord URI changed: " + this.uri + "->" + curi.getURI());
        }
        this.statusCode = curi.getFetchStatus();
        this.disposition = disposition;
        if (this.statusCode == 301 || this.statusCode == 302) {
            for (CrawlURI cauri : curi.getOutLinks()) {
                if (!"location:".equalsIgnoreCase(cauri.getViaContext().toString())) continue;
                this.redirectUri = cauri.toString();
            }
        } else {
            this.redirectUri = null;
        }
    }

    public String getDisposition() {
        return this.disposition;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getUri() {
        return this.uri;
    }

    public int sortShiftStatusCode() {
        return -this.statusCode - Integer.MAX_VALUE;
    }

    public String getKey() {
        return this.uri;
    }

    public void makeDirty() {
        this.cache.dirtyKey(this.getKey());
    }

    public void setIdentityCache(ObjectIdentityCache<?> cache) {
        this.cache = cache;
    }
}

