/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.reporting;

import com.sleepycat.collections.StoredIterator;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import org.archive.bdb.DisposableStoredSortedMap;
import org.archive.crawler.reporting.Report;
import org.archive.crawler.reporting.SeedRecord;
import org.archive.crawler.reporting.StatisticsTracker;

public class SeedsReport
extends Report {
    @Override
    public void write(PrintWriter writer, StatisticsTracker stats) {
        writer.print("[code] [status] [seed] [redirect]\n");
        long seedsCrawled = 0L;
        long seedsTotal = 0L;
        DisposableStoredSortedMap<Integer, SeedRecord> seedsByCode = stats.calcSeedRecordsSortedByStatusCode();
        Iterator iter = seedsByCode.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            SeedRecord sr = (SeedRecord)entry.getValue();
            writer.print(sr.getStatusCode());
            writer.print(" ");
            ++seedsTotal;
            if (sr.getStatusCode() > 0) {
                ++seedsCrawled;
                writer.print("CRAWLED");
            } else {
                writer.print("NOTCRAWLED");
            }
            writer.print(" ");
            writer.print(sr.getUri());
            if (sr.getRedirectUri() != null) {
                writer.print(" ");
                writer.print(sr.getRedirectUri());
            }
            writer.print("\n");
        }
        StoredIterator.close(iter);
        seedsByCode.dispose();
        stats.seedsTotal = seedsTotal;
        stats.seedsCrawled = seedsCrawled;
    }

    @Override
    public String getFilename() {
        return "seeds-report.txt";
    }
}

