/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.reporting;

import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import org.archive.bdb.DisposableStoredSortedMap;
import org.archive.crawler.reporting.Report;
import org.archive.crawler.reporting.StatisticsTracker;

public class SourceTagsReport
extends Report {
    @Override
    public void write(PrintWriter writer, StatisticsTracker stats) {
        Set sourceTags = stats.sourceHostDistribution.keySet();
        if (sourceTags.isEmpty()) {
            writer.println("No source tag information. (Is 'sourceTagSeeds' enabled?)");
            return;
        }
        writer.print("[source] [host] [#urls]\n");
        for (String sourceKey : sourceTags) {
            Map hostCounts = stats.sourceHostDistribution.get(sourceKey);
            DisposableStoredSortedMap<Long, String> sortedHostCounts = stats.getReverseSortedHostCounts(hostCounts);
            for (Map.Entry entry : sortedHostCounts.entrySet()) {
                writer.print(sourceKey.toString());
                writer.print(" ");
                writer.print((String)entry.getValue());
                writer.print(" ");
                writer.print(Math.abs((Long)entry.getKey()));
                writer.print("\n");
            }
            sortedHostCounts.dispose();
        }
    }

    @Override
    public String getFilename() {
        return "source-report.txt";
    }
}

