/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.reporting;

import com.sleepycat.je.DatabaseException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections.Closure;
import org.archive.bdb.BdbModule;
import org.archive.bdb.DisposableStoredSortedMap;
import org.archive.checkpointing.Checkpoint;
import org.archive.checkpointing.Checkpointable;
import org.archive.crawler.event.CrawlStateEvent;
import org.archive.crawler.event.CrawlURIDispositionEvent;
import org.archive.crawler.event.StatSnapshotEvent;
import org.archive.crawler.framework.CrawlController;
import org.archive.crawler.reporting.CrawlStatSnapshot;
import org.archive.crawler.reporting.CrawlSummaryReport;
import org.archive.crawler.reporting.FrontierSummaryReport;
import org.archive.crawler.reporting.HostsReport;
import org.archive.crawler.reporting.MimetypesReport;
import org.archive.crawler.reporting.ProcessorsReport;
import org.archive.crawler.reporting.Report;
import org.archive.crawler.reporting.ResponseCodeReport;
import org.archive.crawler.reporting.SeedRecord;
import org.archive.crawler.reporting.SeedsReport;
import org.archive.crawler.reporting.SourceTagsReport;
import org.archive.crawler.reporting.ToeThreadsReport;
import org.archive.crawler.util.CrawledBytesHistotable;
import org.archive.modules.CrawlURI;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.ServerCache;
import org.archive.modules.seeds.SeedListener;
import org.archive.modules.seeds.SeedModule;
import org.archive.spring.ConfigPath;
import org.archive.util.ArchiveUtils;
import org.archive.util.FileUtils;
import org.archive.util.JSONUtils;
import org.archive.util.MimetypeUtils;
import org.archive.util.ObjectIdentityCache;
import org.archive.util.ObjectIdentityMemCache;
import org.archive.util.PaddingStringBuffer;
import org.archive.util.Supplier;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.Lifecycle;
import org.xbill.DNS.Lookup;

public class StatisticsTracker
implements ApplicationContextAware,
ApplicationListener<ApplicationEvent>,
SeedListener,
Lifecycle,
Runnable,
Checkpointable,
BeanNameAware {
    private static final long serialVersionUID = 6L;
    protected SeedModule seeds;
    protected BdbModule bdb;
    protected ConfigPath reportsDir = new ConfigPath("reports subdirectory", "${launchId}/reports");
    protected ServerCache serverCache;
    protected int liveHostReportSize = 20;
    protected ApplicationContext appCtx;
    private static final Logger logger = Logger.getLogger(StatisticsTracker.class.getName());
    protected boolean trackSeeds = true;
    protected boolean trackSources = true;
    protected int intervalSeconds = 20;
    protected int keepSnapshotsCount = 5;
    protected CrawlController controller;
    protected long crawlStartTime;
    protected long crawlEndTime = -1L;
    protected long crawlPauseStarted = 0L;
    protected long crawlTotalPausedTime = 0L;
    protected LinkedList<CrawlStatSnapshot> snapshots = new LinkedList();
    protected ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    protected CrawledBytesHistotable crawledBytes = new CrawledBytesHistotable();
    protected ConcurrentMap<String, AtomicLong> mimeTypeDistribution = new ConcurrentHashMap<String, AtomicLong>();
    protected ConcurrentMap<String, AtomicLong> mimeTypeBytes = new ConcurrentHashMap<String, AtomicLong>();
    protected ConcurrentMap<String, AtomicLong> statusCodeDistribution = new ConcurrentHashMap<String, AtomicLong>();
    protected ConcurrentHashMap<String, ConcurrentMap<String, AtomicLong>> sourceHostDistribution = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, CrawledBytesHistotable> statsBySource = new ConcurrentHashMap();
    protected ObjectIdentityCache<SeedRecord> processedSeedsRecords = new ObjectIdentityMemCache();
    protected long seedsTotal = -1L;
    protected long seedsCrawled = -1L;
    protected List<Report> reports;
    protected boolean isRunning = false;
    protected String beanName;
    protected Checkpoint recoveryCheckpoint;

    public SeedModule getSeeds() {
        return this.seeds;
    }

    @Autowired
    public void setSeeds(SeedModule seeds) {
        this.seeds = seeds;
    }

    @Autowired
    public void setBdbModule(BdbModule bdb) {
        this.bdb = bdb;
    }

    public ConfigPath getReportsDir() {
        return this.reportsDir;
    }

    public void setReportsDir(ConfigPath reportsDir) {
        this.reportsDir = reportsDir;
    }

    public ServerCache getServerCache() {
        return this.serverCache;
    }

    @Autowired
    public void setServerCache(ServerCache serverCache) {
        this.serverCache = serverCache;
    }

    public int getLiveHostReportSize() {
        return this.liveHostReportSize;
    }

    public void setLiveHostReportSize(int liveHostReportSize) {
        this.liveHostReportSize = liveHostReportSize;
    }

    public void setApplicationContext(ApplicationContext appCtx) throws BeansException {
        this.appCtx = appCtx;
    }

    public boolean getTrackSeeds() {
        return this.trackSeeds;
    }

    public void setTrackSeeds(boolean trackSeeds) {
        this.trackSeeds = trackSeeds;
    }

    public boolean getTrackSources() {
        return this.trackSources;
    }

    public void setTrackSources(boolean trackSources) {
        this.trackSources = trackSources;
    }

    public int getIntervalSeconds() {
        return this.intervalSeconds;
    }

    public void setIntervalSeconds(int interval) {
        this.intervalSeconds = interval;
    }

    public int getKeepSnapshotsCount() {
        return this.keepSnapshotsCount;
    }

    public void setKeepSnapshotsCount(int count) {
        this.keepSnapshotsCount = count;
    }

    public CrawlController getCrawlController() {
        return this.controller;
    }

    @Autowired
    public void setCrawlController(CrawlController controller) {
        this.controller = controller;
    }

    public CrawledBytesHistotable getCrawledBytes() {
        return this.crawledBytes;
    }

    public List<Report> getReports() {
        if (this.reports == null) {
            this.reports = new LinkedList<Report>();
            this.reports.add(new CrawlSummaryReport());
            this.reports.add(new SeedsReport());
            this.reports.add(new HostsReport());
            this.reports.add(new SourceTagsReport());
            this.reports.add(new MimetypesReport());
            this.reports.add(new ResponseCodeReport());
            this.reports.add(new ProcessorsReport());
            this.reports.add(new FrontierSummaryReport());
            this.reports.add(new ToeThreadsReport());
        }
        return this.reports;
    }

    public void setReports(List<Report> reports) {
        this.reports = reports;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void stop() {
        this.isRunning = false;
        this.executor.shutdownNow();
        this.progressStatisticsEvent();
        this.dumpReports();
    }

    public void start() {
        this.isRunning = true;
        boolean isRecover = this.recoveryCheckpoint != null;
        try {
            this.processedSeedsRecords = this.bdb.getObjectCache("processedSeedsRecords", isRecover, SeedRecord.class);
            if (isRecover) {
                JSONObject json = this.recoveryCheckpoint.loadJson(this.beanName);
                this.crawlStartTime = json.getLong("crawlStartTime");
                this.crawlEndTime = json.getLong("crawlEndTime");
                this.crawlTotalPausedTime = json.getLong("crawlTotalPausedTime");
                this.crawlPauseStarted = json.getLong("crawlPauseStarted");
                this.tallyCurrentPause();
                JSONUtils.putAllAtomicLongs(this.mimeTypeDistribution, (JSONObject)json.getJSONObject("mimeTypeDistribution"));
                JSONUtils.putAllAtomicLongs(this.mimeTypeBytes, (JSONObject)json.getJSONObject("mimeTypeBytes"));
                JSONUtils.putAllAtomicLongs(this.statusCodeDistribution, (JSONObject)json.getJSONObject("statusCodeDistribution"));
                JSONObject shd = json.getJSONObject("sourceHostDistribution");
                Iterator keyIter = shd.keys();
                while (keyIter.hasNext()) {
                    String source = (String)keyIter.next();
                    ConcurrentHashMap hostUriCount = new ConcurrentHashMap();
                    JSONUtils.putAllAtomicLongs(hostUriCount, (JSONObject)shd.getJSONObject(source));
                    this.sourceHostDistribution.put(source, hostUriCount);
                }
                JSONObject ss = json.optJSONObject("statsBySource");
                if (ss != null) {
                    keyIter = ss.keys();
                    while (keyIter.hasNext()) {
                        String source = (String)keyIter.next();
                        CrawledBytesHistotable cb = new CrawledBytesHistotable();
                        JSONUtils.putAllLongs((Map)cb, (JSONObject)ss.getJSONObject(source));
                        this.statsBySource.put(source, cb);
                    }
                }
                JSONUtils.putAllLongs((Map)this.crawledBytes, (JSONObject)json.getJSONObject("crawledBytes"));
            }
        }
        catch (DatabaseException e) {
            throw new IllegalStateException(e);
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
        this.controller.logProgressStatistics(this.progressStatisticsLegend());
        this.executor.scheduleAtFixedRate(this, 0L, this.getIntervalSeconds(), TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        try {
            this.progressStatisticsEvent();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "unexpected exception from progressStatisticsEvent()", e);
        }
    }

    public String progressStatisticsLegend() {
        return "           timestamp  discovered      queued   downloaded       doc/s(avg)  KB/s(avg)   dl-failures   busy-thread   mem-use-KB  heap-size-KB   congestion   max-depth   avg-depth";
    }

    public String getProgressStamp() {
        return this.progressStatisticsLegend() + "\n" + this.getSnapshot().getProgressStatisticsLine();
    }

    public void noteStart() {
        if (this.crawlStartTime == 0L) {
            this.crawlStartTime = System.currentTimeMillis();
        }
    }

    protected synchronized void progressStatisticsEvent() {
        CrawlStatSnapshot snapshot = this.getSnapshot();
        if (this.controller != null) {
            this.controller.logProgressStatistics(snapshot.getProgressStatisticsLine());
        }
        this.snapshots.addFirst(snapshot);
        while (this.snapshots.size() > this.getKeepSnapshotsCount()) {
            this.snapshots.removeLast();
        }
        this.appCtx.publishEvent((ApplicationEvent)new StatSnapshotEvent(this, snapshot));
        Lookup.getDefaultCache((int)1).clearCache();
    }

    public CrawlStatSnapshot getSnapshot() {
        CrawlStatSnapshot snapshot = new CrawlStatSnapshot();
        snapshot.collect(this.controller, this);
        return snapshot;
    }

    public LinkedList<CrawlStatSnapshot> listSnapshots() {
        return this.snapshots;
    }

    public CrawlStatSnapshot getLastSnapshot() {
        CrawlStatSnapshot snap = this.snapshots.peek();
        return snap == null ? this.getSnapshot() : snap;
    }

    public long getCrawlElapsedTime() {
        if (this.crawlStartTime == 0L) {
            return 0L;
        }
        if (this.crawlPauseStarted != 0L) {
            return this.crawlPauseStarted - this.crawlTotalPausedTime - this.crawlStartTime;
        }
        return (this.crawlEndTime > 0L ? this.crawlEndTime : System.currentTimeMillis()) - this.crawlTotalPausedTime - this.crawlStartTime;
    }

    public void crawlPausing(String statusMessage) {
        this.logNote("CRAWL WAITING - " + statusMessage);
    }

    protected void logNote(String note) {
        this.controller.logProgressStatistics(new PaddingStringBuffer().append(ArchiveUtils.getLog14Date((Date)new Date())).append(" ").append(note).toString());
    }

    public void crawlPaused(String statusMessage) {
        this.crawlPauseStarted = System.currentTimeMillis();
        this.progressStatisticsEvent();
        this.logNote("CRAWL PAUSED - " + statusMessage);
    }

    public void crawlResuming(String statusMessage) {
        this.tallyCurrentPause();
        if (this.crawlStartTime == 0L) {
            this.noteStart();
        }
        this.logNote("CRAWL RUNNING - " + statusMessage);
    }

    public void crawlEmpty(String statusMessage) {
        this.logNote("CRAWL EMPTY - " + statusMessage);
    }

    protected void tallyCurrentPause() {
        if (this.crawlPauseStarted > 0L) {
            this.crawlTotalPausedTime += System.currentTimeMillis() - this.crawlPauseStarted;
        }
        this.crawlPauseStarted = 0L;
    }

    public void crawlEnding(String sExitMessage) {
        this.logNote("CRAWL ENDING - " + sExitMessage);
    }

    public void crawlEnded(String sExitMessage) {
        this.crawlEndTime = System.currentTimeMillis();
        this.logNote("CRAWL ENDED - " + sExitMessage);
    }

    public long getCrawlDuration() {
        return (this.crawlEndTime > 0L ? this.crawlEndTime : System.currentTimeMillis()) - this.crawlStartTime;
    }

    public Map<String, AtomicLong> getFileDistribution() {
        return this.mimeTypeDistribution;
    }

    protected static void incrementMapCount(ConcurrentMap<String, AtomicLong> map, String key) {
        StatisticsTracker.incrementMapCount(map, key, 1L);
    }

    protected static void incrementMapCount(ConcurrentMap<String, AtomicLong> map, String key, long increment) {
        AtomicLong prevVal;
        AtomicLong lw;
        if (key == null) {
            key = "unknown";
        }
        if ((lw = (AtomicLong)map.get(key)) == null && (prevVal = map.putIfAbsent(key, lw = new AtomicLong(0L))) != null) {
            lw = prevVal;
        }
        lw.addAndGet(increment);
    }

    public DisposableStoredSortedMap<Long, String> getReverseSortedCopy(Map<String, AtomicLong> mapOfAtomicLongValues) {
        DisposableStoredSortedMap sortedMap = this.bdb.getStoredMap(null, Long.class, String.class, true, false);
        for (String k : mapOfAtomicLongValues.keySet()) {
            sortedMap.put((Object)(-mapOfAtomicLongValues.get(k).longValue()), (Object)k);
        }
        return sortedMap;
    }

    public Map<String, AtomicLong> getStatusCodeDistribution() {
        return this.statusCodeDistribution;
    }

    public long getHostLastFinished(String host) {
        return this.serverCache.getHostFor(host).getSubstats().getLastSuccessTime();
    }

    public long getBytesPerHost(String host) {
        return this.serverCache.getHostFor(host).getSubstats().getTotalBytes();
    }

    public long getBytesPerFileType(String filetype) {
        return this.getReportValue(this.mimeTypeBytes, filetype);
    }

    public int threadCount() {
        return this.controller != null ? this.controller.getToeCount() : 0;
    }

    public String crawledBytesSummary() {
        return this.crawledBytes.summary();
    }

    protected void handleSeed(final CrawlURI curi, final String disposition) {
        if (this.getTrackSeeds() && curi.isSeed()) {
            SeedRecord sr = (SeedRecord)this.processedSeedsRecords.getOrUse(curi.getURI(), (Supplier)new Supplier<SeedRecord>(){

                public SeedRecord get() {
                    return new SeedRecord(curi, disposition);
                }
            });
            sr.updateWith(curi, disposition);
        }
    }

    public void crawledURISuccessful(CrawlURI curi) {
        this.handleSeed(curi, "Seed successfully crawled");
        this.crawledBytes.accumulate(curi);
        StatisticsTracker.incrementMapCount(this.statusCodeDistribution, Integer.toString(curi.getFetchStatus()));
        String mime = MimetypeUtils.truncate((String)curi.getContentType());
        StatisticsTracker.incrementMapCount(this.mimeTypeDistribution, mime);
        StatisticsTracker.incrementMapCount(this.mimeTypeBytes, mime, curi.getContentSize());
        ServerCache sc = this.serverCache;
        if (this.getTrackSources() && curi.getData().containsKey("source")) {
            this.saveSourceStats(curi.getSourceTag(), sc.getHostFor(curi.getUURI()).getHostName());
            this.tallySourceStats(curi);
        }
    }

    protected void saveSourceStats(String source, String hostname) {
        ConcurrentMap<String, AtomicLong> prevVal;
        ConcurrentMap<String, AtomicLong> hostUriCount = this.sourceHostDistribution.get(source);
        if (hostUriCount == null && (prevVal = this.sourceHostDistribution.putIfAbsent(source, hostUriCount = new ConcurrentHashMap<String, AtomicLong>())) != null) {
            hostUriCount = prevVal;
        }
        StatisticsTracker.incrementMapCount(hostUriCount, hostname);
    }

    protected void tallySourceStats(CrawlURI curi) {
        String source = curi.getSourceTag();
        CrawledBytesHistotable sourceStats = this.statsBySource.get(source);
        if (sourceStats == null) {
            sourceStats = new CrawledBytesHistotable();
            this.statsBySource.put(source, sourceStats);
        }
        sourceStats.accumulate(curi);
    }

    public void crawledURINeedRetry(CrawlURI curi) {
        this.handleSeed(curi, "Failed to crawl seed, will retry");
    }

    public void crawledURIDisregard(CrawlURI curi) {
        this.handleSeed(curi, "Seed was disregarded");
    }

    public void crawledURIFailure(CrawlURI curi) {
        this.handleSeed(curi, "Failed to crawl seed");
    }

    public Iterator<String> getSeedsIterator() {
        return this.processedSeedsRecords.keySet().iterator();
    }

    public DisposableStoredSortedMap<Integer, SeedRecord> calcSeedRecordsSortedByStatusCode() {
        Iterator<String> i = this.getSeedsIterator();
        DisposableStoredSortedMap sortedMap = this.bdb.getStoredMap(null, Integer.class, SeedRecord.class, true, false);
        while (i.hasNext()) {
            String seed = i.next();
            SeedRecord sr = (SeedRecord)this.processedSeedsRecords.get(seed);
            if (sr == null) {
                sr = new SeedRecord(seed, "Seed has not been processed");
            }
            sortedMap.put((Object)sr.sortShiftStatusCode(), (Object)sr);
        }
        return sortedMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisposableStoredSortedMap<Long, String> getReverseSortedHostCounts(Map<String, AtomicLong> hostCounts) {
        Map<String, AtomicLong> map = hostCounts;
        synchronized (map) {
            return this.getReverseSortedCopy(hostCounts);
        }
    }

    public DisposableStoredSortedMap<Long, String> calcReverseSortedHostsDistribution() {
        final DisposableStoredSortedMap sortedMap = this.bdb.getStoredMap(null, Long.class, String.class, true, false);
        this.serverCache.forAllHostsDo(new Closure(){

            public void execute(Object hostObj) {
                CrawlHost host = (CrawlHost)hostObj;
                sortedMap.put((Object)(-host.getSubstats().getFetchSuccesses()), (Object)host.getHostName());
            }
        });
        return sortedMap;
    }

    public File writeReportFile(String reportName) {
        for (Report report : this.getReports()) {
            if (!report.getClass().getSimpleName().equals(reportName)) continue;
            return this.writeReportFile(report, false);
        }
        return null;
    }

    protected File writeReportFile(Report report, boolean force) {
        File f = new File(this.getReportsDir().getFile(), report.getFilename());
        if (f.exists() && !this.controller.isRunning() && this.controller.hasStarted() && !force && !(report instanceof CrawlSummaryReport)) {
            logger.info("reusing report: " + f.getAbsolutePath());
            return f;
        }
        try {
            FileUtils.ensureWriteableDirectory((File)f.getParentFile());
            PrintWriter bw = new PrintWriter(new FileWriter(f));
            report.write(bw, this);
            bw.close();
            this.addToManifest(f.getAbsolutePath(), 'R', true);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Unable to write " + f.getAbsolutePath() + " at the end of crawl.", e);
        }
        logger.info("wrote report: " + f.getAbsolutePath());
        return f;
    }

    protected void addToManifest(String absolutePath, char manifest_report_file, boolean b) {
    }

    public void dumpReports() {
        for (Report report : this.getReports()) {
            if (!report.getShouldReportAtEndOfCrawl()) continue;
            try {
                this.writeReportFile(report, true);
            }
            catch (RuntimeException re) {
                logger.log(Level.SEVERE, re.getMessage(), re);
            }
        }
    }

    public void crawlCheckpoint(Object def, File cpDir) throws Exception {
        this.logNote("CRAWL CHECKPOINTING TO " + cpDir.toString());
    }

    private long getReportValue(Map<String, AtomicLong> map, String key) {
        if (key == null) {
            return -1L;
        }
        AtomicLong o = map.get(key);
        if (o == null) {
            return -2L;
        }
        if (!(o instanceof AtomicLong)) {
            throw new IllegalStateException("Expected AtomicLong but got " + o.getClass() + " for " + key);
        }
        return o.get();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof CrawlStateEvent) {
            CrawlStateEvent event1 = (CrawlStateEvent)event;
            switch (event1.getState()) {
                case PAUSED: {
                    this.crawlPaused(event1.getMessage());
                    break;
                }
                case RUNNING: {
                    this.crawlResuming(event1.getMessage());
                    break;
                }
                case EMPTY: {
                    this.crawlEmpty(event1.getMessage());
                    break;
                }
                case PAUSING: {
                    this.crawlPausing(event1.getMessage());
                    break;
                }
                case STOPPING: {
                    this.crawlEnding(event1.getMessage());
                    break;
                }
                case FINISHED: {
                    this.crawlEnded(event1.getMessage());
                    break;
                }
                case PREPARING: {
                    this.crawlResuming(event1.getMessage());
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown state: " + (Object)((Object)event1.getState()));
                }
            }
        }
        if (event instanceof CrawlURIDispositionEvent) {
            CrawlURIDispositionEvent dvent = (CrawlURIDispositionEvent)event;
            switch (dvent.getDisposition()) {
                case SUCCEEDED: {
                    this.crawledURISuccessful(dvent.getCrawlURI());
                    break;
                }
                case FAILED: {
                    this.crawledURIFailure(dvent.getCrawlURI());
                    break;
                }
                case DISREGARDED: {
                    this.crawledURIDisregard(dvent.getCrawlURI());
                    break;
                }
                case DEFERRED_FOR_RETRY: {
                    this.crawledURINeedRetry(dvent.getCrawlURI());
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown disposition: " + (Object)((Object)dvent.getDisposition()));
                }
            }
        }
    }

    public void tallySeeds() {
        this.seedsTotal = 0L;
        this.seedsCrawled = 0L;
        if (this.processedSeedsRecords == null) {
            return;
        }
        Iterator<String> i = this.getSeedsIterator();
        while (i.hasNext()) {
            SeedRecord sr = (SeedRecord)this.processedSeedsRecords.get(i.next());
            ++this.seedsTotal;
            if (sr == null || sr.getStatusCode() <= 0) continue;
            ++this.seedsCrawled;
        }
    }

    public void addedSeed(CrawlURI curi) {
        this.handleSeed(curi, "");
    }

    public boolean nonseedLine(String line) {
        return false;
    }

    public void concludedSeedBatch() {
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void startCheckpoint(Checkpoint checkpointInProgress) {
    }

    public void doCheckpoint(Checkpoint checkpointInProgress) throws IOException {
        JSONObject json = new JSONObject();
        try {
            json.put("crawlStartTime", this.crawlStartTime);
            json.put("crawlEndTime", this.crawlEndTime);
            long virtualCrawlPauseStarted = this.crawlPauseStarted;
            if (virtualCrawlPauseStarted < 1L) {
                virtualCrawlPauseStarted = System.currentTimeMillis();
            }
            json.put("crawlPauseStarted", virtualCrawlPauseStarted);
            json.put("crawlTotalPausedTime", this.crawlTotalPausedTime);
            json.put("mimeTypeDistribution", this.mimeTypeDistribution);
            json.put("mimeTypeBytes", this.mimeTypeBytes);
            json.put("statusCodeDistribution", this.statusCodeDistribution);
            json.put("sourceHostDistribution", this.sourceHostDistribution);
            json.put("statsBySource", this.statsBySource);
            json.put("crawledBytes", (Map)this.crawledBytes);
            checkpointInProgress.saveJson(this.beanName, json);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public void finishCheckpoint(Checkpoint checkpointInProgress) {
    }

    public void setRecoveryCheckpoint(Checkpoint recoveryCheckpoint) {
        this.recoveryCheckpoint = recoveryCheckpoint;
    }

    public CrawledBytesHistotable getSourceStats(String source) {
        return this.statsBySource.get(source);
    }
}

