/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.restlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang.StringEscapeUtils;
import org.archive.crawler.restlet.EnhDirectoryResource;
import org.archive.crawler.restlet.Flash;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.representation.CharacterRepresentation;
import org.restlet.representation.FileRepresentation;

public class EditRepresentation
extends CharacterRepresentation {
    protected FileRepresentation fileRepresentation;
    protected EnhDirectoryResource dirResource;

    public EditRepresentation(FileRepresentation representation, EnhDirectoryResource resource) {
        super(MediaType.TEXT_HTML);
        this.fileRepresentation = representation;
        this.dirResource = resource;
        this.setCharacterSet(CharacterSet.UTF_8);
    }

    public Reader getReader() throws IOException {
        StringWriter writer = new StringWriter((int)this.fileRepresentation.getSize() + 100);
        this.write(writer);
        return new StringReader(writer.toString());
    }

    protected String getStaticRef(String resource) {
        String rootRef = this.dirResource.getRequest().getRootRef().toString();
        return rootRef + "/engine/static/" + resource;
    }

    public void write(Writer writer) throws IOException {
        PrintWriter pw = new PrintWriter(writer);
        pw.println("<!DOCTYPE html>");
        pw.println("<html>");
        pw.println("<head><title>" + this.fileRepresentation.getFile().getName() + "</title>");
        pw.println("<link rel='stylesheet' href='" + this.getStaticRef("codemirror/codemirror.css") + "'>");
        pw.println("<link rel='stylesheet' href='" + this.getStaticRef("codemirror/util/dialog.css") + "'>");
        pw.println("<script src='" + this.getStaticRef("codemirror/codemirror.js") + "'></script>");
        pw.println("<script src='" + this.getStaticRef("codemirror/mode/xmlpure.js") + "'></script>");
        pw.println("<script src='" + this.getStaticRef("codemirror/util/dialog.js") + "'></script>");
        pw.println("<style>.CodeMirror { background: #fff; }</style>");
        pw.println("</head>");
        pw.println("<body style='background-color:#ddd'>");
        pw.println("<form style='position:absolute;top:15px;bottom:15px;left:15px;right:15px;overflow:auto' method='POST'>");
        pw.println("<textarea style='width:98%;height:90%;font-family:monospace' name='contents' id='editor'>");
        StringEscapeUtils.escapeHtml((Writer)pw, (String)this.fileRepresentation.getText());
        pw.println("</textarea>");
        pw.println("<div id='savebar'>");
        pw.println("<input type='submit' value='save changes' id='savebutton'>");
        pw.println(this.fileRepresentation.getFile());
        Reference viewRef = this.dirResource.getRequest().getOriginalRef().clone();
        viewRef.setQuery(null);
        pw.println("<a href='" + viewRef + "'>view</a>");
        Flash.renderFlashesHTML(pw, this.dirResource.getRequest());
        pw.println("</div>");
        pw.println("</form>");
        pw.println("<script>");
        pw.println("var editor = document.getElementById('editor');");
        pw.println("var savebar = document.getElementById('savebar');");
        pw.println("var savebutton = document.getElementById('savebutton');");
        pw.println("var cmopts = {");
        pw.println("    mode: {name: 'xmlpure'},");
        pw.println("    indentUnit: 1, lineNumbers: true, autofocus: true,");
        pw.println("    onChange: function() { savebutton.disabled = false; },");
        pw.println("}");
        pw.println("var cm = CodeMirror.fromTextArea(editor, cmopts);");
        pw.println("window.onresize = function() {");
        pw.println("    cm.getScrollerElement().style.height = innerHeight - savebar.offsetHeight - 30 + 'px';");
        pw.println("    cm.refresh();");
        pw.println("}");
        pw.println("window.onresize();");
        pw.println("savebutton.disabled = true;");
        pw.println("</script>");
        pw.println("</body>");
        pw.println("</html>");
    }

    public FileRepresentation getFileRepresentation() {
        return this.fileRepresentation;
    }
}

