/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.restlet;

import freemarker.template.ObjectWrapper;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.archive.crawler.framework.CrawlJob;
import org.archive.crawler.restlet.BaseResource;
import org.archive.crawler.restlet.Flash;
import org.archive.crawler.restlet.XmlMarshaller;
import org.archive.crawler.restlet.models.EngineModel;
import org.archive.crawler.restlet.models.ViewModel;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.representation.WriterRepresentation;
import org.restlet.resource.ResourceException;

public class EngineResource
extends BaseResource {
    public void init(Context ctx, Request req, Response res) {
        super.init(ctx, req, res);
        this.getVariants().add(new Variant(MediaType.TEXT_HTML));
        this.getVariants().add(new Variant(MediaType.APPLICATION_XML));
    }

    protected Representation get(Variant variant) throws ResourceException {
        if (variant.getMediaType() == MediaType.APPLICATION_XML) {
            return new WriterRepresentation(MediaType.APPLICATION_XML){

                public void write(Writer writer) throws IOException {
                    XmlMarshaller.marshalDocument(writer, "engine", EngineResource.this.makeDataModel());
                }
            };
        }
        ViewModel viewModel = new ViewModel();
        viewModel.put("fileSeparator", File.separator);
        viewModel.put("engine", this.makeDataModel());
        return this.render("Engine.ftl", viewModel, ObjectWrapper.DEFAULT_WRAPPER);
    }

    protected Representation post(Representation entity, Variant variant) throws ResourceException {
        Form form = new Form(entity);
        String action = form.getFirstValue("action");
        if ("rescan".equals(action)) {
            this.getEngine().findJobConfigs();
        } else if ("add".equals(action)) {
            String path = form.getFirstValue("addpath");
            if (path == null) {
                Flash.addFlash(this.getResponse(), "Cannot add <i>null</i> path", Flash.Kind.NACK);
            } else {
                File jobFile = new File(path);
                String jobName = jobFile.getName();
                if (!jobFile.isDirectory()) {
                    Flash.addFlash(this.getResponse(), "Cannot add non-directory: <i>" + path + "</i>", Flash.Kind.NACK);
                } else if (this.getEngine().getJobConfigs().containsKey(jobName)) {
                    Flash.addFlash(this.getResponse(), "Job exists: <i>" + jobName + "</i>", Flash.Kind.NACK);
                } else if (this.getEngine().addJobDirectory(new File(path))) {
                    Flash.addFlash(this.getResponse(), "Added crawl job: '" + path + "'", Flash.Kind.ACK);
                } else {
                    Flash.addFlash(this.getResponse(), "Could not add job: '" + path + "'", Flash.Kind.NACK);
                }
            }
        } else if ("create".equals(action)) {
            String path = form.getFirstValue("createpath");
            if (path == null) {
                Flash.addFlash(this.getResponse(), "Cannot create <i>null</i> path.", Flash.Kind.NACK);
            } else if (path.indexOf(File.separatorChar) != -1) {
                Flash.addFlash(this.getResponse(), "Sub-directories disallowed: <i>" + path + "</i>", Flash.Kind.NACK);
            } else if (this.getEngine().getJobConfigs().containsKey(path)) {
                Flash.addFlash(this.getResponse(), "Job exists: <i>" + path + "</i>", Flash.Kind.NACK);
            } else {
                File newJobDir = new File(this.getEngine().getJobsDir(), path);
                if (newJobDir.exists()) {
                    Flash.addFlash(this.getResponse(), "Directory exists: <i>" + path + "</i>", Flash.Kind.NACK);
                } else if (this.getEngine().createNewJobWithDefaults(newJobDir)) {
                    Flash.addFlash(this.getResponse(), "Created new crawl job: <i>" + path + "</i>", Flash.Kind.ACK);
                    this.getEngine().findJobConfigs();
                } else {
                    Flash.addFlash(this.getResponse(), "Failed to create new job: <i>" + path + "</i>", Flash.Kind.NACK);
                }
            }
        } else if ("exit java process".equals(action)) {
            boolean cancel = false;
            if (!"on".equals(form.getFirstValue("im_sure"))) {
                Flash.addFlash(this.getResponse(), "You must tick \"I'm sure\" to trigger exit", Flash.Kind.NACK);
                cancel = true;
            }
            for (Map.Entry<String, CrawlJob> entry : this.getBuiltJobs().entrySet()) {
                if ("on".equals(form.getFirstValue("ignore__" + entry.getKey()))) continue;
                Flash.addFlash(this.getResponse(), "Job '" + entry.getKey() + "' still &laquo;" + entry.getValue().getJobStatusDescription() + "&raquo;", Flash.Kind.NACK);
                cancel = true;
            }
            if (!cancel) {
                Flash.addFlash(this.getResponse(), "Shutting down ... bye");
                new Thread(() -> {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    System.exit(0);
                }).start();
            }
        } else if ("gc".equals(action)) {
            System.gc();
        }
        this.getResponse().redirectSeeOther(this.getRequest().getOriginalRef());
        return new EmptyRepresentation();
    }

    protected HashMap<String, CrawlJob> getBuiltJobs() {
        HashMap<String, CrawlJob> builtJobs = new HashMap<String, CrawlJob>();
        for (Map.Entry<String, CrawlJob> entry : this.getEngine().getJobConfigs().entrySet()) {
            if (!entry.getValue().hasApplicationContext()) continue;
            builtJobs.put(entry.getKey(), entry.getValue());
        }
        return builtJobs;
    }

    protected EngineModel makeDataModel() {
        String baseRef = this.getRequest().getResourceRef().getBaseRef().toString();
        if (!baseRef.endsWith("/")) {
            baseRef = baseRef + "/";
        }
        return new EngineModel(this.getEngine(), baseRef);
    }
}

