/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.restlet;

import java.io.File;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.archive.crawler.restlet.EnhDirectoryResource;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.resource.Directory;
import org.restlet.resource.ServerResource;

public abstract class EnhDirectory
extends Directory {
    protected IOFileFilter editFilter = FileFilterUtils.falseFileFilter();
    protected IOFileFilter pageFilter = FileFilterUtils.falseFileFilter();
    protected IOFileFilter tailFilter = FileFilterUtils.falseFileFilter();

    public EnhDirectory(Context context, Reference rootLocalReference) {
        super(context, rootLocalReference);
    }

    public EnhDirectory(Context context, String rootUri) {
        super(context, rootUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Request request, Response response) {
        EnhDirectory enhDirectory = this;
        synchronized (enhDirectory) {
            Reference oldRef = this.getRootRef();
            this.setRootRef(this.determineRootRef(request));
            try {
                super.handle(request, response);
            }
            finally {
                this.setRootRef(oldRef);
            }
            if (response.getStatus() == Status.SUCCESS_NO_CONTENT) {
                response.setStatus(Status.SUCCESS_OK);
            }
        }
    }

    public ServerResource create(Request request, Response response) {
        return new EnhDirectoryResource();
    }

    protected abstract Reference determineRootRef(Request var1);

    public boolean allowsEdit(File file) {
        return this.editFilter.accept(file);
    }

    public void setEditFilter(IOFileFilter fileFilter) {
        this.editFilter = fileFilter;
    }

    public boolean allowsPaging(File file) {
        return true;
    }
}

