/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.restlet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.io.FileUtils;
import org.archive.crawler.restlet.EditRepresentation;
import org.archive.crawler.restlet.EnhDirectory;
import org.archive.crawler.restlet.Flash;
import org.archive.crawler.restlet.PagedRepresentation;
import org.restlet.data.CharacterSet;
import org.restlet.data.Form;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.local.DirectoryServerResource;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.FileRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.ResourceException;

public class EnhDirectoryResource
extends DirectoryServerResource {
    public List<Variant> getVariants() {
        List superVariants = super.getVariants();
        if (superVariants == null) {
            return null;
        }
        LinkedList<Object> variants = new LinkedList<Variant>(superVariants);
        Form f = this.getRequest().getResourceRef().getQueryAsForm();
        String format = f.getFirstValue("format");
        if ("textedit".equals(format)) {
            if (variants.isEmpty()) {
                try {
                    File file = new File(new URI(this.getTargetUri()));
                    if (this.getEnhDirectory().allowsEdit(file)) {
                        file.createNewFile();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                superVariants = super.getVariants();
                if (superVariants == null) {
                    return null;
                }
                variants = new LinkedList(superVariants);
            }
            ListIterator<EditRepresentation> iter = variants.listIterator();
            while (iter.hasNext()) {
                Variant v = (Variant)iter.next();
                if (!(v instanceof FileRepresentation)) continue;
                File file = ((FileRepresentation)v).getFile();
                if (!this.getEnhDirectory().allowsEdit(file)) continue;
                iter.remove();
                v.setCharacterSet(CharacterSet.UTF_8);
                iter.add(new EditRepresentation((FileRepresentation)v, this));
            }
        } else if ("paged".equals(format)) {
            ListIterator<PagedRepresentation> iter = variants.listIterator();
            while (iter.hasNext()) {
                Variant v = (Variant)iter.next();
                if (!(v instanceof FileRepresentation)) continue;
                File file = ((FileRepresentation)v).getFile();
                if (!this.getEnhDirectory().allowsPaging(file)) continue;
                iter.remove();
                iter.add(new PagedRepresentation((FileRepresentation)v, this, f.getFirstValue("pos"), f.getFirstValue("lines"), f.getFirstValue("reverse")));
            }
        } else {
            ListIterator iter = variants.listIterator();
            while (iter.hasNext()) {
                Variant v = (Variant)iter.next();
                v.setCharacterSet(CharacterSet.UTF_8);
            }
        }
        return variants;
    }

    protected EnhDirectory getEnhDirectory() {
        return (EnhDirectory)this.getDirectory();
    }

    protected Representation post(Representation entity) throws ResourceException {
        Form form = new Form(entity);
        String newContents = form.getFirstValue("contents");
        File file = new File(URI.create(this.getTargetUri()));
        try {
            FileUtils.writeStringToFile((File)file, (String)newContents, (String)"UTF-8");
            Flash.addFlash(this.getResponse(), "file updated");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Reference ref = this.getRequest().getOriginalRef().clone();
        this.getResponse().redirectSeeOther(ref);
        return new EmptyRepresentation();
    }

    public Representation put(Representation entity) throws ResourceException {
        File file = new File(URI.create(this.getTargetUri()));
        if (this.getTargetUri().endsWith("/") || file.isDirectory()) {
            return super.put(entity);
        }
        boolean created = !file.exists();
        try (FileOutputStream out = new FileOutputStream(file);){
            entity.write((OutputStream)out);
        }
        catch (FileNotFoundException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, (Throwable)e);
        }
        catch (IOException e) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, (Throwable)e);
        }
        if (created) {
            this.getResponse().setStatus(Status.SUCCESS_CREATED);
        }
        return new EmptyRepresentation();
    }
}

