/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.restlet;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.CookieSetting;
import org.restlet.util.Series;

public class Flash {
    protected static long nextdrop = RandomUtils.nextLong();
    protected static Map<Long, Flash> dropboxes = new LinkedHashMap<Long, Flash>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, Flash> eldest) {
            return this.size() > 100;
        }
    };
    protected Kind kind;
    protected String message;

    public static void addFlash(Response response, String message) {
        Flash.addFlash(response, message, Kind.ACK);
    }

    public static void addFlash(Response response, String message, Kind kind) {
        dropboxes.put(nextdrop, new Flash(message, kind));
        Series cookies = response.getCookieSettings();
        CookieSetting flashdrop = null;
        for (CookieSetting cs : cookies) {
            if (!cs.getName().equals("flashdrop")) continue;
            flashdrop = cs;
        }
        if (flashdrop == null) {
            cookies.add((Object)new CookieSetting("flashdrop", Long.toString(nextdrop)));
        } else {
            flashdrop.setValue(flashdrop.getValue() + "," + Long.toString(nextdrop));
        }
        ++nextdrop;
    }

    public static List<Flash> getFlashes(Request request) {
        LinkedList<Flash> flashes = new LinkedList<Flash>();
        Series cookies = request.getCookies();
        String flashdrops = cookies.getFirstValue("flashdrop");
        if (StringUtils.isBlank((String)flashdrops)) {
            return flashes;
        }
        for (String dropbox : flashdrops.split(",")) {
            Flash flash;
            if (dropbox == null || (flash = dropboxes.remove(Long.parseLong(dropbox))) == null) continue;
            flashes.add(flash);
        }
        return flashes;
    }

    public static void renderFlashesHTML(Writer writer, Request request) {
        PrintWriter pw = new PrintWriter(writer);
        for (Flash flash : Flash.getFlashes(request)) {
            pw.println("<div class='flash" + (Object)((Object)flash.getKind()) + "'>");
            pw.println(flash.getMessage());
            pw.println("</div>");
        }
        pw.flush();
    }

    public Flash(String message) {
        this(message, Kind.ACK);
    }

    public Flash(String message, Kind kind) {
        this.kind = kind;
        this.message = message;
    }

    public boolean isExpired() {
        return true;
    }

    public String getMessage() {
        return this.message;
    }

    public Kind getKind() {
        return this.kind;
    }

    public static enum Kind {
        ACK,
        NACK,
        ADVISORY;

    }
}

