/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.restlet;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Logger;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang.StringUtils;
import org.archive.crawler.framework.CrawlJob;
import org.archive.crawler.reporting.AlertHandler;
import org.archive.crawler.reporting.AlertThreadGroup;
import org.archive.crawler.restlet.BaseResource;
import org.archive.crawler.restlet.Flash;
import org.archive.crawler.restlet.XmlMarshaller;
import org.archive.crawler.restlet.models.CrawlJobModel;
import org.archive.crawler.restlet.models.ViewModel;
import org.archive.util.FileUtils;
import org.archive.util.TextUtils;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.representation.WriterRepresentation;
import org.restlet.resource.ResourceException;

public class JobResource
extends BaseResource {
    public static final IOFileFilter EDIT_FILTER = FileUtils.getRegexFileFilter((String)".*\\.((c?xml)|(txt))$");
    private static final Logger logger = Logger.getLogger(JobResource.class.getName());
    protected CrawlJob cj;

    public void init(Context ctx, Request req, Response res) throws ResourceException {
        super.init(ctx, req, res);
        this.getVariants().add(new Variant(MediaType.TEXT_HTML));
        this.getVariants().add(new Variant(MediaType.APPLICATION_XML));
        this.cj = this.getEngine().getJob(TextUtils.urlUnescape((String)((String)req.getAttributes().get("job"))));
    }

    public Representation get(Variant variant) throws ResourceException {
        if (this.cj == null) {
            throw new ResourceException(404);
        }
        if (variant.getMediaType() == MediaType.APPLICATION_XML) {
            return new WriterRepresentation(MediaType.APPLICATION_XML){

                public void write(Writer writer) throws IOException {
                    CrawlJobModel model = JobResource.this.makeDataModel();
                    model.put("heapReport", JobResource.this.getEngine().heapReportData());
                    XmlMarshaller.marshalDocument(writer, "job", model);
                }
            };
        }
        ViewModel viewModel = new ViewModel();
        viewModel.put("heapReport", this.getEngine().heapReportData());
        viewModel.put("job", this.makeDataModel());
        return this.render("Job.ftl", viewModel);
    }

    protected CrawlJobModel makeDataModel() {
        String baseRef = this.getRequest().getResourceRef().getBaseRef().toString();
        if (!baseRef.endsWith("/")) {
            baseRef = baseRef + "/";
        }
        return new CrawlJobModel(this.cj, baseRef);
    }

    public static String getHrefPath(File f, CrawlJob cj) {
        String jobDirRelative = cj.jobDirRelativePath(f);
        if (jobDirRelative != null) {
            return "jobdir/" + jobDirRelative;
        }
        String fullPath = f.getAbsolutePath();
        fullPath = fullPath.replace(File.separatorChar, '/');
        return "../../anypath/" + fullPath;
    }

    public Representation post(Representation entity, Variant variant) throws ResourceException {
        if (this.cj == null) {
            throw new ResourceException(404);
        }
        Form form = new Form(entity);
        String copyTo = form.getFirstValue("copyTo");
        if (copyTo != null) {
            this.copyJob(copyTo, "on".equals(form.getFirstValue("asProfile")));
            return new EmptyRepresentation();
        }
        AlertHandler.ensureStaticInitialization();
        AlertThreadGroup.setThreadLogger(this.cj.getJobLogger());
        String action = form.getFirstValue("action");
        if ("launch".equals(action)) {
            String selectedCheckpoint = form.getFirstValue("checkpoint");
            if (StringUtils.isNotEmpty((String)selectedCheckpoint)) {
                this.cj.getCheckpointService().setRecoveryCheckpointByName(selectedCheckpoint);
            }
            this.cj.launch();
        } else if ("checkXML".equals(action)) {
            this.cj.checkXML();
        } else if ("instantiate".equals(action)) {
            this.cj.instantiateContainer();
        } else if ("build".equals(action) || "validate".equals(action)) {
            this.cj.validateConfiguration();
        } else if ("teardown".equals(action)) {
            if (!this.cj.teardown()) {
                Flash.addFlash(this.getResponse(), "waiting for job to finish", Flash.Kind.NACK);
            }
        } else if ("pause".equals(action)) {
            this.cj.getCrawlController().requestCrawlPause();
        } else if ("unpause".equals(action)) {
            this.cj.getCrawlController().requestCrawlResume();
        } else if ("checkpoint".equals(action)) {
            String cp = this.cj.getCheckpointService().requestCrawlCheckpoint();
            if (StringUtils.isNotEmpty((String)cp)) {
                Flash.addFlash(this.getResponse(), "Checkpoint <i>" + cp + "</i> saved", Flash.Kind.ACK);
            } else {
                Flash.addFlash(this.getResponse(), "Checkpoint not made -- perhaps no progress since last? (see logs)", Flash.Kind.NACK);
            }
        } else if ("terminate".equals(action)) {
            this.cj.terminate();
        }
        AlertThreadGroup.setThreadLogger(null);
        this.getResponse().redirectSeeOther(this.getRequest().getOriginalRef());
        return new EmptyRepresentation();
    }

    protected void copyJob(String copyTo, boolean asProfile) throws ResourceException {
        try {
            this.getEngine().copy(this.cj, copyTo, asProfile);
        }
        catch (IOException e) {
            Flash.addFlash(this.getResponse(), "Job not copied: " + e.getMessage(), Flash.Kind.NACK);
            this.getResponse().redirectSeeOther(this.getRequest().getOriginalRef());
            return;
        }
        this.getResponse().redirectSeeOther(copyTo);
    }
}

