/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.restlet;

import java.util.logging.Logger;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.ext.crypto.DigestAuthenticator;

public class RateLimitGuard
extends DigestAuthenticator {
    private static final int MIN_MS_BETWEEN_ATTEMPTS = 6000;
    private static final Logger logger = Logger.getLogger(RateLimitGuard.class.getName());
    protected long lastFailureTime = 0L;

    public RateLimitGuard(Context context, String realm, String serverKey) throws IllegalArgumentException {
        super(context, realm, serverKey);
    }

    protected boolean authenticate(Request request, Response response) {
        boolean succeeded = super.authenticate(request, response);
        String authHeader = request.getHeaders().getFirstValue("Authorization", true);
        if (authHeader != null && !succeeded) {
            logger.warning("authentication failure " + request);
            long now = System.currentTimeMillis();
            long sleepMs = this.lastFailureTime + 6000L - now;
            if (sleepMs > 0L) {
                try {
                    Thread.sleep(sleepMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.lastFailureTime = now;
        }
        return succeeded;
    }
}

