/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.restlet;

import java.io.File;
import org.archive.crawler.restlet.JobRelatedResource;
import org.archive.crawler.restlet.JobResource;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ResourceException;

public class ReportGenResource
extends JobRelatedResource {
    protected String reportClass;

    @Override
    public void init(Context ctx, Request req, Response res) throws ResourceException {
        super.init(ctx, req, res);
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.reportClass = (String)req.getAttributes().get("reportClass");
    }

    protected Representation get(Variant variant) throws ResourceException {
        if (this.cj == null || this.cj.getCrawlController() == null) {
            throw new ResourceException(500);
        }
        File f = this.cj.getCrawlController().getStatisticsTracker().writeReportFile(this.reportClass);
        if (f == null) {
            throw new ResourceException(500);
        }
        String relative = JobResource.getHrefPath(f, this.cj);
        if (relative != null) {
            this.getResponse().redirectSeeOther("../" + relative + "?m=" + f.lastModified());
            return new StringRepresentation((CharSequence)"");
        }
        return new StringRepresentation((CharSequence)("Report dumped to " + f.getAbsolutePath() + " (outside job directory)"));
    }
}

