/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.restlet;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.apache.commons.lang.StringUtils;
import org.archive.crawler.restlet.JobRelatedResource;
import org.archive.crawler.restlet.ScriptingConsole;
import org.archive.crawler.restlet.XmlMarshaller;
import org.archive.crawler.restlet.models.ScriptModel;
import org.archive.crawler.restlet.models.ViewModel;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.representation.WriterRepresentation;
import org.restlet.resource.ResourceException;

public class ScriptResource
extends JobRelatedResource {
    protected static ScriptEngineManager MANAGER = new ScriptEngineManager();
    protected static LinkedList<ScriptEngineFactory> FACTORIES = new LinkedList();
    protected String chosenEngine = FACTORIES.isEmpty() ? "" : FACTORIES.getFirst().getNames().get(0);
    private ScriptingConsole scriptingConsole;

    @Override
    public void init(Context ctx, Request req, Response res) throws ResourceException {
        super.init(ctx, req, res);
        this.getVariants().add(new Variant(MediaType.TEXT_HTML));
        this.getVariants().add(new Variant(MediaType.APPLICATION_XML));
        this.scriptingConsole = new ScriptingConsole(this.cj);
    }

    public Representation post(Representation entity, Variant variant) throws ResourceException {
        Form form = new Form(entity);
        this.chosenEngine = form.getFirstValue("engine");
        String script = form.getFirstValue("script");
        if (StringUtils.isBlank((String)script)) {
            script = "";
        }
        ScriptEngine eng = MANAGER.getEngineByName(this.chosenEngine);
        this.scriptingConsole.bind("scriptResource", (Object)this);
        this.scriptingConsole.execute(eng, script);
        this.scriptingConsole.unbind("scriptResource");
        return this.get(variant);
    }

    public Representation get(Variant variant) throws ResourceException {
        if (variant.getMediaType() == MediaType.APPLICATION_XML) {
            return new WriterRepresentation(MediaType.APPLICATION_XML){

                public void write(Writer writer) throws IOException {
                    XmlMarshaller.marshalDocument(writer, "script", ScriptResource.this.makeDataModel());
                }
            };
        }
        ViewModel viewModel = new ViewModel();
        viewModel.put("baseResourceRef", this.getRequest().getRootRef().toString() + "/engine/static/");
        viewModel.put("model", this.makeDataModel());
        viewModel.put("selectedEngine", this.chosenEngine);
        viewModel.put("staticRef", this.getStaticRef(""));
        return this.render("Script.ftl", viewModel);
    }

    protected Collection<Map<String, String>> getAvailableScriptEngines() {
        LinkedList<Map<String, String>> engines = new LinkedList<Map<String, String>>();
        for (ScriptEngineFactory f : FACTORIES) {
            LinkedHashMap<String, String> engine = new LinkedHashMap<String, String>();
            engine.put("engine", f.getNames().get(0));
            engine.put("language", f.getLanguageName());
            engines.add(engine);
        }
        return engines;
    }

    protected ScriptModel makeDataModel() {
        String baseRef = this.getRequest().getResourceRef().getBaseRef().toString();
        if (!baseRef.endsWith("/")) {
            baseRef = baseRef + "/";
        }
        Reference baseRefRef = new Reference(baseRef);
        ScriptModel model = new ScriptModel(this.scriptingConsole, new Reference(baseRefRef, "..").getTargetRef().toString(), this.getAvailableScriptEngines());
        return model;
    }

    static {
        FACTORIES.addAll(MANAGER.getEngineFactories());
        Collections.sort(FACTORIES, new Comparator<ScriptEngineFactory>(){

            @Override
            public int compare(ScriptEngineFactory sef1, ScriptEngineFactory sef2) {
                return sef1.getEngineName().compareTo(sef2.getEngineName());
            }
        });
    }
}

