/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.restlet;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.archive.crawler.framework.BeanLookupBindings;
import org.archive.crawler.framework.CrawlJob;
import org.springframework.context.ApplicationContext;

public class ScriptingConsole {
    private final CrawlJob cj;
    private ScriptEngine eng;
    private String script;
    private Bindings bindings;
    private StringWriter rawString;
    private StringWriter htmlString;
    private Throwable exception;
    private int linesExecuted;
    private List<Map<String, String>> availableGlobalVariables;

    public ScriptingConsole(CrawlJob job) {
        this.cj = job;
        this.bindings = new BeanLookupBindings((ApplicationContext)this.cj.getJobContext());
        this.script = "";
        this.setupAvailableGlobalVariables();
    }

    protected void addGlobalVariable(String name, String desc) {
        LinkedHashMap<String, String> var = new LinkedHashMap<String, String>();
        var.put("variable", name);
        var.put("description", desc);
        this.availableGlobalVariables.add(var);
    }

    private void setupAvailableGlobalVariables() {
        this.availableGlobalVariables = new LinkedList<Map<String, String>>();
        this.addGlobalVariable("rawOut", "a PrintWriter for arbitrary text output to this page");
        this.addGlobalVariable("htmlOut", "a PrintWriter for HTML output to this page");
        this.addGlobalVariable("job", "the current CrawlJob instance");
        this.addGlobalVariable("appCtx", "current job ApplicationContext, if any");
        this.addGlobalVariable("scriptResource", "the ScriptResource implementing this page, which offers utility methods");
    }

    public void bind(String name, Object obj) {
        this.bindings.put(name, obj);
    }

    public Object unbind(String name) {
        return this.bindings.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ScriptEngine eng, String script) {
        this.eng = eng;
        this.script = script;
        this.bind("job", this.cj);
        this.rawString = new StringWriter();
        this.htmlString = new StringWriter();
        PrintWriter rawOut = new PrintWriter(this.rawString);
        PrintWriter htmlOut = new PrintWriter(this.htmlString);
        this.bind("rawOut", rawOut);
        this.bind("htmlOut", htmlOut);
        this.bind("appCtx", this.cj.getJobContext());
        this.exception = null;
        try {
            this.eng.eval(this.script, this.bindings);
            this.linesExecuted = script.split("\r?\n").length;
        }
        catch (ScriptException ex) {
            Throwable cause = ex.getCause();
            this.exception = cause != null ? cause : ex;
        }
        catch (RuntimeException ex) {
            this.exception = ex;
        }
        finally {
            rawOut.flush();
            htmlOut.flush();
            this.unbind("rawOut");
            this.unbind("htmlOut");
            this.unbind("appCtx");
            this.unbind("job");
        }
    }

    public CrawlJob getCrawlJob() {
        return this.cj;
    }

    public Throwable getException() {
        return this.exception;
    }

    public int getLinesExecuted() {
        return this.linesExecuted;
    }

    public String getRawOutput() {
        return this.rawString != null ? this.rawString.toString() : "";
    }

    public String getHtmlOutput() {
        return this.htmlString != null ? this.htmlString.toString() : "";
    }

    public String getScript() {
        return this.script;
    }

    public List<Map<String, String>> getAvailableGlobalVariables() {
        return this.availableGlobalVariables;
    }
}

