/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.restlet;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.restlet.ext.xml.XmlWriter;
import org.xml.sax.SAXException;

public class XmlMarshaller {
    protected static XmlWriter getXmlWriter(Writer writer) {
        XmlWriter xmlWriter = new XmlWriter(writer);
        xmlWriter.setDataFormat(true);
        xmlWriter.setIndentStep(2);
        return xmlWriter;
    }

    public static void marshalDocument(Writer writer, String rootTag, Object content) throws IOException {
        XmlWriter xmlWriter = XmlMarshaller.getXmlWriter(writer);
        try {
            xmlWriter.startDocument();
            XmlMarshaller.marshal(xmlWriter, rootTag, content);
            xmlWriter.endDocument();
        }
        catch (SAXException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            throw new RuntimeException(e);
        }
    }

    protected static void orderProperties(PropertyDescriptor[] props, String[] propOrder) {
        if (propOrder == null || propOrder.length == 0) {
            return;
        }
        final HashMap<String, Integer> order = new HashMap<String, Integer>();
        for (int i = 0; i < propOrder.length; ++i) {
            order.put(propOrder[i], i);
        }
        final Integer LAST = propOrder.length;
        Arrays.sort(props, new Comparator<PropertyDescriptor>(){

            @Override
            public int compare(PropertyDescriptor o1, PropertyDescriptor o2) {
                Integer c1 = (Integer)order.get(o1.getName());
                Integer c2 = (Integer)order.get(o2.getName());
                return (c1 != null ? c1 : LAST).compareTo(c2 != null ? c2 : LAST);
            }
        });
    }

    protected static boolean marshalAsElement(Object obj) {
        XmlRootElement ann = obj.getClass().getAnnotation(XmlRootElement.class);
        return ann != null;
    }

    protected static void marshalBean(XmlWriter xmlWriter, String key, Object obj) throws SAXException {
        if (!StringUtils.isEmpty((String)key)) {
            xmlWriter.startElement(key);
        }
        try {
            String[] propOrder;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass(), Object.class);
            PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
            XmlType xmlType = obj.getClass().getAnnotation(XmlType.class);
            if (xmlType != null && (propOrder = xmlType.propOrder()) != null) {
                XmlMarshaller.orderProperties(props, propOrder);
            }
            for (PropertyDescriptor prop : props) {
                Method m = prop.getReadMethod();
                if (m == null || m.getAnnotation(XmlTransient.class) != null) continue;
                try {
                    Object propValue = m.invoke(obj, new Object[0]);
                    if (propValue == null || "".equals(propValue)) continue;
                    XmlMarshaller.marshal(xmlWriter, prop.getName(), propValue);
                }
                catch (Exception ex) {
                    xmlWriter.emptyElement(prop.getName());
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        if (!StringUtils.isEmpty((String)key)) {
            xmlWriter.endElement(key);
        }
    }

    protected static void marshal(XmlWriter xmlWriter, String key, Object value) throws SAXException {
        if (value == null) {
            xmlWriter.emptyElement(key);
        } else if (value instanceof Map) {
            XmlMarshaller.marshal(xmlWriter, key, (Map)value);
        } else if (value instanceof Iterable) {
            XmlMarshaller.marshal(xmlWriter, key, (Iterable)value);
        } else if (XmlMarshaller.marshalAsElement(value)) {
            XmlMarshaller.marshalBean(xmlWriter, key, value);
        } else {
            xmlWriter.dataElement(key, value.toString());
        }
    }

    protected static void marshal(XmlWriter xmlWriter, String key, Map<?, ?> map) throws SAXException {
        xmlWriter.startElement(key);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            XmlMarshaller.marshal(xmlWriter, entry.getKey().toString(), entry.getValue());
        }
        xmlWriter.endElement(key);
    }

    protected static void marshal(XmlWriter xmlWriter, String key, Iterable<?> iterable) throws SAXException {
        xmlWriter.startElement(key);
        for (Object item : iterable) {
            XmlMarshaller.marshal(xmlWriter, item);
        }
        xmlWriter.endElement(key);
    }

    protected static void marshal(XmlWriter xmlWriter, Object item) throws SAXException {
        if (item instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)item;
            XmlMarshaller.marshal(xmlWriter, entry.getKey().toString(), entry.getValue());
        } else {
            XmlMarshaller.marshal(xmlWriter, "value", item);
        }
    }
}

