/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.restlet.models;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.archive.checkpointing.Checkpoint;
import org.archive.crawler.framework.CrawlController;
import org.archive.crawler.framework.CrawlJob;
import org.archive.crawler.reporting.Report;
import org.archive.spring.ConfigPath;
import org.archive.util.ArchiveUtils;
import org.archive.util.FileUtils;

public class CrawlJobModel
extends LinkedHashMap<String, Object>
implements Serializable {
    private CrawlJob crawlJob;
    public static final IOFileFilter EDIT_FILTER = FileUtils.getRegexFileFilter((String)".*\\.((c?xml)|(txt))$");

    public CrawlJobModel(CrawlJob crawlJob, String urlBaseRef) {
        Checkpoint recoveryCheckpoint;
        this.crawlJob = crawlJob;
        this.put("shortName", crawlJob.getShortName());
        if (crawlJob.getCrawlController() != null) {
            this.put("crawlControllerState", crawlJob.getCrawlController().getState());
            if (crawlJob.getCrawlController().getState() == CrawlController.State.FINISHED) {
                this.put("crawlExitStatus", crawlJob.getCrawlController().getCrawlExitStatus());
            }
        }
        this.put("statusDescription", crawlJob.getJobStatusDescription());
        LinkedHashSet<String> actions = new LinkedHashSet<String>();
        this.put("availableActions", actions);
        this.put("launchCount", crawlJob.getLaunchCount());
        this.put("lastLaunch", crawlJob.getLastLaunch());
        this.put("isProfile", crawlJob.isProfile());
        File primaryConfig = FileUtils.tryToCanonicalize((File)crawlJob.getPrimaryConfig());
        this.put("primaryConfig", primaryConfig.getAbsolutePath());
        this.put("primaryConfigUrl", urlBaseRef + "jobdir/" + primaryConfig.getName());
        this.put("url", urlBaseRef + "job/" + crawlJob.getShortName());
        this.put("jobLogTail", this.generateJobLogTail());
        this.put("uriTotalsReport", crawlJob.uriTotalsReportData());
        Map<String, Long> sizeTotalsReportData = crawlJob.sizeTotalsReportData();
        if (sizeTotalsReportData == null) {
            sizeTotalsReportData = new LinkedHashMap<String, Long>();
        }
        if (!sizeTotalsReportData.containsKey("dupByHash")) {
            sizeTotalsReportData.put("dupByHash", 0L);
        }
        if (!sizeTotalsReportData.containsKey("dupByHashCount")) {
            sizeTotalsReportData.put("dupByHashCount", 0L);
        }
        if (!sizeTotalsReportData.containsKey("novel")) {
            sizeTotalsReportData.put("novel", 0L);
        }
        if (!sizeTotalsReportData.containsKey("novelCount")) {
            sizeTotalsReportData.put("novelCount", 0L);
        }
        if (!sizeTotalsReportData.containsKey("notModified")) {
            sizeTotalsReportData.put("notModified", 0L);
        }
        if (!sizeTotalsReportData.containsKey("notModifiedCount")) {
            sizeTotalsReportData.put("notModifiedCount", 0L);
        }
        if (!sizeTotalsReportData.containsKey("total")) {
            sizeTotalsReportData.put("total", 0L);
        }
        if (!sizeTotalsReportData.containsKey("totalCount")) {
            sizeTotalsReportData.put("totalCount", 0L);
        }
        this.put("sizeTotalsReport", sizeTotalsReportData);
        this.put("rateReport", crawlJob.rateReportData());
        this.put("loadReport", crawlJob.loadReportData());
        this.put("elapsedReport", crawlJob.elapsedReportData());
        this.put("threadReport", crawlJob.threadReportData());
        this.put("frontierReport", crawlJob.frontierReportData());
        this.put("crawlLogTail", this.generateCrawlLogTail());
        this.put("configFiles", this.generateConfigReferencedPaths(urlBaseRef));
        this.put("isLaunchInfoPartial", crawlJob.isLaunchInfoPartial());
        this.put("isRunning", crawlJob.isRunning());
        this.put("isLaunchable", crawlJob.isLaunchable());
        this.put("hasApplicationContext", crawlJob.hasApplicationContext());
        this.put("alertCount", crawlJob.getAlertCount());
        if (!crawlJob.hasApplicationContext()) {
            actions.add("build");
        }
        if (!crawlJob.isProfile() && crawlJob.isLaunchable()) {
            actions.add("launch");
        }
        if (crawlJob.isPausable()) {
            actions.add("pause");
        }
        if (crawlJob.isUnpausable()) {
            actions.add("unpause");
        }
        if (crawlJob.getCheckpointService() != null && crawlJob.isRunning()) {
            actions.add("checkpoint");
        }
        if (crawlJob.isRunning()) {
            actions.add("terminate");
        }
        if (crawlJob.hasApplicationContext()) {
            actions.add("teardown");
        }
        if (crawlJob.getCheckpointService() != null && (recoveryCheckpoint = crawlJob.getCheckpointService().getRecoveryCheckpoint()) != null) {
            this.put("checkpointName", recoveryCheckpoint.getName());
        }
        ArrayList<String> checkpointFiles = new ArrayList<String>();
        if (crawlJob.getCheckpointService() != null && crawlJob.isLaunchable() && crawlJob.getCheckpointService().hasAvailableCheckpoints()) {
            for (File f : crawlJob.getCheckpointService().findAvailableCheckpointDirectories()) {
                checkpointFiles.add(f.getName());
            }
        }
        this.put("checkpointFiles", checkpointFiles);
        if (crawlJob.hasApplicationContext()) {
            this.put("alertLogFilePath", crawlJob.getCrawlController().getLoggerModule().getAlertsLogPath().getFile().getAbsolutePath());
        }
        if (crawlJob.isRunning() || crawlJob.hasApplicationContext() && !crawlJob.isLaunchable()) {
            this.put("crawlLogFilePath", crawlJob.getCrawlController().getLoggerModule().getCrawlLogPath().getFile().getAbsolutePath());
        }
        this.put("reports", this.generateReports());
    }

    public String formatBytes(Long bytes) {
        return ArchiveUtils.formatBytesForDisplay((long)bytes);
    }

    public String doubleToString(double number, int digits) {
        return ArchiveUtils.doubleToString((double)number, (int)digits);
    }

    public String getLastLaunchTime() {
        long ago = System.currentTimeMillis() - this.crawlJob.getLastLaunch().toEpochMilli();
        return ArchiveUtils.formatMillisecondsToConventional((long)ago, (int)2);
    }

    public File getConfigurationFilePath() {
        return this.crawlJob.getPrimaryConfig();
    }

    public List<String> generateJobLogTail() {
        ArrayList<String> jobLog = new ArrayList<String>();
        if (this.crawlJob.getJobLog().exists()) {
            try {
                FileUtils.pagedLines((File)this.crawlJob.getJobLog(), (long)-1L, (int)-5, jobLog);
                Collections.reverse(jobLog);
            }
            catch (IOException ioe) {
                return null;
            }
        }
        return jobLog;
    }

    public List<String> generateCrawlLogTail() {
        LinkedList<String> logLines = new LinkedList<String>();
        if ((this.crawlJob.isRunning() || this.crawlJob.hasApplicationContext() && !this.crawlJob.isLaunchable()) && this.crawlJob.getCrawlController().getLoggerModule().getCrawlLogPath().getFile().exists()) {
            try {
                FileUtils.pagedLines((File)this.crawlJob.getCrawlController().getLoggerModule().getCrawlLogPath().getFile(), (long)-1L, (int)-10, logLines);
                Collections.reverse(logLines);
            }
            catch (IOException ioe) {
                return null;
            }
        }
        return logLines;
    }

    public List<Map<String, String>> generateReports() {
        ArrayList<Map<String, String>> reports = new ArrayList<Map<String, String>>();
        if (this.crawlJob.hasApplicationContext()) {
            for (Report report : this.crawlJob.getCrawlController().getStatisticsTracker().getReports()) {
                if (!report.getShouldReportDuringCrawl()) continue;
                LinkedHashMap<String, String> reportMap = new LinkedHashMap<String, String>();
                String className = report.getClass().getSimpleName();
                reportMap.put("className", className);
                reportMap.put("shortName", className.substring(0, className.length() - "Report".length()));
                reports.add(reportMap);
            }
        }
        return reports;
    }

    private List<Map<String, Object>> generateConfigReferencedPaths(String baseRef) {
        ArrayList<Map<String, Object>> referencedPaths = new ArrayList<Map<String, Object>>();
        for (String key : this.crawlJob.getConfigPaths().keySet()) {
            ConfigPath cp = this.crawlJob.getConfigPaths().get(key);
            LinkedHashMap<String, Object> configMap = new LinkedHashMap<String, Object>();
            configMap.put("key", key);
            configMap.put("name", cp.getName());
            configMap.put("path", FileUtils.tryToCanonicalize((File)cp.getFile()).getAbsolutePath());
            configMap.put("url", baseRef + "engine/anypath/" + configMap.get("path"));
            configMap.put("editable", EDIT_FILTER.accept(cp.getFile()));
            referencedPaths.add(configMap);
        }
        return referencedPaths;
    }
}

