/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.spring;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.crawler.spring.DecideRuledSheetAssociation;
import org.archive.crawler.spring.SurtPrefixesSheetAssociation;
import org.archive.modules.CrawlURI;
import org.archive.spring.OverlayMapsSource;
import org.archive.spring.Sheet;
import org.archive.url.UsableURI;
import org.archive.util.PrefixFinder;
import org.archive.util.SurtPrefixSet;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class SheetOverlaysManager
implements BeanFactoryAware,
OverlayMapsSource,
ApplicationListener<ApplicationEvent> {
    private static final Logger logger = Logger.getLogger(SheetOverlaysManager.class.getName());
    protected BeanFactory beanFactory;
    protected SortedSet<DecideRuledSheetAssociation> ruleAssociations = new ConcurrentSkipListSet<DecideRuledSheetAssociation>();
    protected NavigableMap<String, List<String>> sheetNamesBySurt = new ConcurrentSkipListMap<String, List<String>>();
    protected Map<String, Sheet> sheetsByName = new ConcurrentHashMap<String, Sheet>();

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Autowired(required=false)
    public void setSheetsByName(Map<String, Sheet> map) {
        this.sheetsByName = map;
    }

    public Map<String, Sheet> getSheetsByName() {
        return this.sheetsByName;
    }

    public SortedSet<DecideRuledSheetAssociation> getRuleAssociations() {
        return this.ruleAssociations;
    }

    public NavigableMap<String, List<String>> getSheetsNamesBySurt() {
        return this.sheetNamesBySurt;
    }

    @Autowired(required=false)
    public void addRuleAssociations(Set<DecideRuledSheetAssociation> associations) {
        this.ruleAssociations.clear();
        this.ruleAssociations.addAll(associations);
    }

    public void addRuleAssociation(DecideRuledSheetAssociation assoc) {
        this.ruleAssociations.add(assoc);
    }

    @Autowired(required=false)
    public void addSurtAssociations(List<SurtPrefixesSheetAssociation> associations) {
        for (SurtPrefixesSheetAssociation association : associations) {
            this.addSurtsAssociation(association);
        }
    }

    public void addSurtAssociation(String prefix, String sheetName) {
        LinkedList<String> sheetNames = (LinkedList<String>)this.sheetNamesBySurt.get(prefix);
        if (sheetNames == null) {
            sheetNames = new LinkedList<String>();
        }
        sheetNames.add(sheetName);
        this.sheetNamesBySurt.put(prefix, sheetNames);
    }

    public boolean removeSurtAssociation(String prefix, String sheetName) {
        List sheetNames = (List)this.sheetNamesBySurt.get(prefix);
        if (sheetNames == null) {
            return false;
        }
        return sheetNames.remove(sheetName);
    }

    public void addSurtsAssociation(SurtPrefixesSheetAssociation assoc) {
        for (String prefix : assoc.getSurtPrefixes()) {
            for (String s : assoc.getTargetSheetNames()) {
                this.addSurtAssociation(prefix, s);
            }
        }
    }

    public Map<String, Object> getOverlayMap(String name) {
        Sheet sheet = this.sheetsByName.get(name);
        if (sheet != null) {
            return sheet.getMap();
        }
        return null;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            for (Sheet s : this.sheetsByName.values()) {
                s.prime();
            }
            HashSet<String> allSheetNames = new HashSet<String>();
            for (DecideRuledSheetAssociation assoc : this.ruleAssociations) {
                allSheetNames.addAll(assoc.getTargetSheetNames());
            }
            for (List names : this.sheetNamesBySurt.values()) {
                allSheetNames.addAll(names);
            }
            for (String name : allSheetNames) {
                if (this.sheetsByName.containsKey(name)) continue;
                logger.warning("sheet '" + name + "' referenced but absent");
            }
        }
    }

    public Object putSheetOverlay(String sheetName, String beanPath, Object value) {
        Sheet sheet = this.getOrCreateSheet(sheetName);
        Object prevVal = sheet.getMap().put(beanPath, value);
        try {
            sheet.prime();
        }
        catch (TypeMismatchException tme) {
            sheet.getMap().put(beanPath, prevVal);
            throw tme;
        }
        return prevVal;
    }

    public Object removeSheetOverlay(String sheetName, String beanPath) {
        Sheet sheet = this.sheetsByName.get(sheetName);
        if (sheet == null) {
            return null;
        }
        return sheet.getMap().remove(beanPath);
    }

    public boolean deleteSheet(String sheetName) {
        boolean anyDeleted = false;
        for (DecideRuledSheetAssociation assoc : this.ruleAssociations) {
            anyDeleted |= assoc.getTargetSheetNames().remove(sheetName);
        }
        for (List sheetNames : this.sheetNamesBySurt.values()) {
            anyDeleted |= sheetNames.remove(sheetName);
        }
        return anyDeleted |= null != this.sheetsByName.remove(sheetName);
    }

    public Sheet getOrCreateSheet(String name) {
        Sheet sheet = this.sheetsByName.get(name);
        if (sheet == null) {
            sheet = new Sheet();
            sheet.setBeanFactory(this.beanFactory);
            sheet.setName(name);
            sheet.setMap(new HashMap());
            this.sheetsByName.put(name, sheet);
        }
        return sheet;
    }

    public void applyOverlaysTo(CrawlURI curi) {
        curi.setOverlayMapsSource((OverlayMapsSource)this);
        curi.getOverlayNames().clear();
        String effectiveSurt = SurtPrefixSet.getCandidateSurt((UsableURI)curi.getPolicyBasisUURI());
        List foundPrefixes = PrefixFinder.findKeys(this.sheetNamesBySurt, (String)effectiveSurt);
        for (String prefix : foundPrefixes) {
            for (String name : (List)this.sheetNamesBySurt.get(prefix)) {
                curi.getOverlayNames().add(name);
            }
        }
        for (DecideRuledSheetAssociation assoc : this.ruleAssociations) {
            try {
                if (!assoc.getRules().accepts(curi)) continue;
                curi.getOverlayNames().addAll(assoc.getTargetSheetNames());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "problem determining whether to apply overlays, so not applying " + assoc.getTargetSheetNames() + " to " + curi, e);
            }
        }
        curi.getOverlayNames();
    }
}

