/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.archive.util.FileUtils;

public class CheckpointUtils {
    public static final String SERIALIZED_CLASS_SUFFIX = ".serialized";

    public static File getBdbSubDirectory(File checkpointDir) {
        return new File(checkpointDir, "bdbje-logs");
    }

    public static File getClassCheckpointFile(File checkpointDir, String suffix, Class<?> c) {
        return new File(checkpointDir, CheckpointUtils.getClassCheckpointFilename(c, suffix));
    }

    public static File getClassCheckpointFile(File checkpointDir, Class<?> c) {
        return new File(checkpointDir, CheckpointUtils.getClassCheckpointFilename(c, null));
    }

    public static String getClassCheckpointFilename(Class<?> c) {
        return CheckpointUtils.getClassCheckpointFilename(c, null);
    }

    public static String getClassCheckpointFilename(Class<?> c, String suffix) {
        return c.getName() + (suffix == null ? "" : "." + suffix) + SERIALIZED_CLASS_SUFFIX;
    }

    public static void writeObjectToFile(Object o, File dir) throws IOException {
        CheckpointUtils.writeObjectToFile(o, null, dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObjectToFile(Object o, String suffix, File dir) throws IOException {
        FileUtils.ensureWriteableDirectory((File)dir);
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(CheckpointUtils.getClassCheckpointFile(dir, suffix, o.getClass())));){
            out.writeObject(o);
        }
    }

    public static <T> T readObjectFromFile(Class<T> c, File dir) throws FileNotFoundException, IOException, ClassNotFoundException {
        return CheckpointUtils.readObjectFromFile(c, null, dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T readObjectFromFile(Class<T> c, String suffix, File dir) throws FileNotFoundException, IOException, ClassNotFoundException {
        T o = null;
        try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(CheckpointUtils.getClassCheckpointFile(dir, suffix, c)));){
            o = c.cast(in.readObject());
        }
        return o;
    }

    public static FilenameFilter getJeLogsFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name != null && name.toLowerCase().endsWith(".jdb");
            }
        };
    }
}

