/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.util;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongIterators;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.archive.crawler.util.FPMergeUriUniqFilter;
import org.archive.util.ArchiveUtils;

public class DiskFPMergeUriUniqFilter
extends FPMergeUriUniqFilter {
    protected long count = 0L;
    protected File scratchDir;
    protected File currentFps;
    protected File newFpsFile;
    protected DataOutputStream newFps;
    protected long newCount;
    protected DataInputStream oldFps;

    public DiskFPMergeUriUniqFilter(File scratchDir) {
        this.scratchDir = scratchDir;
    }

    @Override
    protected LongIterator beginFpMerge() {
        this.newFpsFile = new File(this.scratchDir, ArchiveUtils.get17DigitDate() + ".fp");
        if (this.newFpsFile.exists()) {
            throw new RuntimeException(this.newFpsFile + " exists");
        }
        try {
            this.newFps = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.newFpsFile)));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.newCount = 0L;
        if (this.currentFps == null) {
            return LongIterators.EMPTY_ITERATOR;
        }
        try {
            this.oldFps = new DataInputStream(new BufferedInputStream(new FileInputStream(this.currentFps)));
        }
        catch (FileNotFoundException e1) {
            throw new RuntimeException(e1);
        }
        return new DataFileLongIterator(this.oldFps);
    }

    @Override
    protected void addNewFp(long fp) {
        try {
            this.newFps.writeLong(fp);
            ++this.newCount;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void finishFpMerge() {
        try {
            this.newFps.close();
            File oldFpsFile = this.currentFps;
            this.currentFps = this.newFpsFile;
            if (this.oldFps != null) {
                this.oldFps.close();
            }
            if (oldFpsFile != null) {
                oldFpsFile.delete();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.count = this.newCount;
    }

    @Override
    public long count() {
        return this.count;
    }

    public class DataFileLongIterator
    implements LongIterator {
        DataInputStream in;
        long next;
        boolean nextIsValid = false;

        public DataFileLongIterator(DataInputStream disStream) {
            this.in = disStream;
        }

        public boolean hasNext() {
            return this.nextIsValid ? true : this.lookahead();
        }

        protected boolean lookahead() {
            try {
                this.next = this.in.readLong();
            }
            catch (IOException e) {
                return false;
            }
            this.nextIsValid = true;
            return true;
        }

        public Long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Long returnObj = new Long(this.next);
            this.nextIsValid = false;
            return returnObj;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.nextIsValid = false;
            return this.next;
        }

        public int skip(int arg0) {
            return 0;
        }
    }
}

