/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.archive.io.CompositeFileReader;
import org.archive.util.ArchiveUtils;

public class LogReader {
    public static String get(String aFileName) {
        try {
            return LogReader.get(new FileReader(aFileName));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String get(InputStreamReader reader) {
        StringBuffer ret = new StringBuffer();
        try {
            BufferedReader bf = new BufferedReader(reader, 8192);
            String line = null;
            while ((line = bf.readLine()) != null) {
                ret.append(line);
                ret.append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return ret.toString();
    }

    public static String[] get(String aFileName, int lineNumber, int n) {
        File f = new File(aFileName);
        long logsize = f.length();
        try {
            return LogReader.get(new FileReader(aFileName), lineNumber, n, logsize);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] getFromSeries(String aFileName, int lineNumber, int n) {
        File f = new File(aFileName);
        long logsize = f.length();
        try {
            return LogReader.get((InputStreamReader)LogReader.seriesReader(aFileName), lineNumber, n, logsize);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String buildDisplayingHeader(int len, long logsize) {
        double percent = 0.0;
        if (logsize != 0L) {
            percent = (double)len / (double)logsize * 100.0;
        }
        return "Displaying: " + ArchiveUtils.doubleToString((double)percent, (int)1) + "% of " + ArchiveUtils.formatBytesForDisplay((long)logsize);
    }

    public static String[] get(InputStreamReader reader, int lineNumber, int n, long logsize) {
        StringBuffer ret = new StringBuffer();
        String info = null;
        try {
            BufferedReader bf = new BufferedReader(reader, 8192);
            String line = null;
            int i = 1;
            while ((line = bf.readLine()) != null) {
                if (i >= lineNumber && i < lineNumber + n) {
                    ret.append(line);
                    ret.append('\n');
                } else if (i >= lineNumber + n) break;
                ++i;
            }
            info = LogReader.buildDisplayingHeader(ret.length(), logsize);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        String[] tmp = new String[]{ret.toString(), info};
        return tmp;
    }

    public static int findFirstLineContaining(String aFileName, String regex) {
        try {
            return LogReader.findFirstLineContaining(new FileReader(aFileName), regex);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int findFirstLineBeginningFromSeries(String aFileName, String prefix) {
        try {
            return LogReader.findFirstLineBeginning((InputStreamReader)LogReader.seriesReader(aFileName), prefix);
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int findFirstLineBeginning(InputStreamReader reader, String prefix) {
        try {
            BufferedReader bf = new BufferedReader(reader, 8192);
            String line = null;
            int i = 1;
            while ((line = bf.readLine()) != null) {
                if (line.startsWith(prefix)) {
                    return i;
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -1;
    }

    public static int findFirstLineContainingFromSeries(String aFileName, String regex) {
        try {
            return LogReader.findFirstLineContaining((InputStreamReader)LogReader.seriesReader(aFileName), regex);
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int findFirstLineContaining(InputStreamReader reader, String regex) {
        Pattern p = Pattern.compile(regex);
        try {
            BufferedReader bf = new BufferedReader(reader, 8192);
            String line = null;
            int i = 1;
            while ((line = bf.readLine()) != null) {
                if (p.matcher(line).matches()) {
                    return i;
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -1;
    }

    public static String[] getByRegex(String aFileName, String regex, int addLines, boolean prependLineNumbers, int skipFirstMatches, int numberOfMatches) {
        try {
            File f = new File(aFileName);
            return LogReader.getByRegex((InputStreamReader)new FileReader(f), regex, addLines, prependLineNumbers, skipFirstMatches, numberOfMatches, f.length());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] getByRegexFromSeries(String aFileName, String regex, int addLines, boolean prependLineNumbers, int skipFirstMatches, int numberOfMatches) {
        try {
            File f = new File(aFileName);
            return LogReader.getByRegex((InputStreamReader)LogReader.seriesReader(aFileName), regex, addLines, prependLineNumbers, skipFirstMatches, numberOfMatches, f.length());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] getByRegex(InputStreamReader reader, String regex, int addLines, boolean prependLineNumbers, int skipFirstMatches, int numberOfMatches, long logsize) {
        StringBuffer ret = new StringBuffer();
        String info = "";
        try {
            Pattern p = Pattern.compile(regex);
            BufferedReader bf = new BufferedReader(reader, 8192);
            String line = null;
            int i = 1;
            boolean doAdd = false;
            int addCount = 0;
            long linesMatched = 0L;
            while ((line = bf.readLine()) != null) {
                if (p.matcher(line).matches()) {
                    if (numberOfMatches > 0 && linesMatched >= (long)(skipFirstMatches + numberOfMatches)) break;
                    if (++linesMatched > (long)skipFirstMatches) {
                        if (prependLineNumbers) {
                            ret.append(i);
                            ret.append(". ");
                        }
                        ret.append(line);
                        ret.append("\n");
                        doAdd = true;
                        addCount = 0;
                    }
                } else if (doAdd) {
                    if (addCount < addLines) {
                        ++linesMatched;
                        if (prependLineNumbers) {
                            ret.append(i);
                            ret.append(". ");
                        }
                        ret.append(line);
                        ret.append("\n");
                    } else {
                        doAdd = false;
                        addCount = 0;
                    }
                }
                ++i;
            }
            info = LogReader.buildDisplayingHeader(ret.length(), logsize);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (PatternSyntaxException e) {
            ret = new StringBuffer(e.getMessage());
        }
        String[] tmp = new String[]{ret.toString(), info};
        return tmp;
    }

    public static String[] getByRegex(String aFileName, String regex, String addLines, boolean prependLineNumbers, int skipFirstMatches, int numberOfMatches) {
        try {
            File f = new File(aFileName);
            return LogReader.getByRegex((InputStreamReader)new FileReader(f), regex, addLines, prependLineNumbers, skipFirstMatches, numberOfMatches, f.length());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] getByRegexFromSeries(String aFileName, String regex, String addLines, boolean prependLineNumbers, int skipFirstMatches, int numberOfMatches) {
        try {
            File f = new File(aFileName);
            return LogReader.getByRegex((InputStreamReader)LogReader.seriesReader(aFileName), regex, addLines, prependLineNumbers, skipFirstMatches, numberOfMatches, f.length());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] getByRegex(InputStreamReader reader, String regex, String addLines, boolean prependLineNumbers, int skipFirstMatches, int numberOfMatches, long logsize) {
        StringBuffer ret = new StringBuffer();
        String info = "";
        try {
            Matcher m = Pattern.compile(regex).matcher("");
            BufferedReader bf = new BufferedReader(reader, 8192);
            String line = null;
            int i = 1;
            boolean doAdd = false;
            long linesMatched = 0L;
            while ((line = bf.readLine()) != null) {
                m.reset(line);
                if (m.matches()) {
                    if (numberOfMatches > 0 && linesMatched >= (long)(skipFirstMatches + numberOfMatches)) break;
                    if (++linesMatched > (long)skipFirstMatches) {
                        if (prependLineNumbers) {
                            ret.append(i);
                            ret.append(". ");
                        }
                        ret.append(line);
                        ret.append("\n");
                        doAdd = true;
                    }
                } else if (doAdd) {
                    if (line.indexOf(addLines) == 0) {
                        ++linesMatched;
                        if (prependLineNumbers) {
                            ret.append(i);
                            ret.append(". ");
                        }
                        ret.append(line);
                        ret.append("\n");
                    } else {
                        doAdd = false;
                    }
                }
                ++i;
            }
            info = LogReader.buildDisplayingHeader(ret.length(), logsize);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (PatternSyntaxException e) {
            ret = new StringBuffer(e.getMessage());
        }
        String[] tmp = new String[]{ret.toString(), info};
        return tmp;
    }

    public static String[] tail(String aFileName) {
        return LogReader.tail(aFileName, 10);
    }

    public static String[] tail(String aFileName, int n) {
        try {
            return LogReader.tail(new RandomAccessFile(new File(aFileName), "r"), n);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] tail(RandomAccessFile raf, int n) {
        int BUFFERSIZE = 1024;
        int numOfLines = 0;
        String info = null;
        byte[] buffer = new byte[BUFFERSIZE];
        StringBuffer sb = new StringBuffer();
        try {
            long pos;
            long endPos;
            long lastPos = endPos = raf.length();
            if (endPos > 0L) {
                byte[] oneByte = new byte[1];
                raf.seek(endPos - 1L);
                raf.read(oneByte);
                if ((char)oneByte[0] != '\n') {
                    ++numOfLines;
                }
            }
            do {
                pos = 0L;
                if (lastPos - (long)BUFFERSIZE > 0L) {
                    pos = lastPos - (long)BUFFERSIZE;
                }
                raf.seek(pos);
                if (lastPos - pos < (long)BUFFERSIZE) {
                    int remainer = (int)(lastPos - pos);
                    buffer = new byte[remainer];
                }
                raf.readFully(buffer);
                for (int i = buffer.length - 1; i >= 0; --i) {
                    if ((char)buffer[i] != '\n' || ++numOfLines <= n) continue;
                    pos += (long)(i + 1);
                    break;
                }
                lastPos = pos;
            } while (numOfLines <= n && pos != 0L);
            for (pos = lastPos; pos < endPos; pos += (long)buffer.length) {
                raf.seek(pos);
                if (endPos - pos < (long)BUFFERSIZE) {
                    int remainer = (int)(endPos - pos);
                    buffer = new byte[remainer];
                }
                raf.readFully(buffer);
                sb.append(new String(buffer));
            }
            info = LogReader.buildDisplayingHeader(sb.length(), raf.length());
        }
        catch (FileNotFoundException e) {
            sb = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            sb = null;
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (sb == null) {
            return null;
        }
        String[] tmp = new String[]{sb.toString(), info};
        return tmp;
    }

    private static CompositeFileReader seriesReader(String fileName) throws IOException {
        LinkedList<File> filenames = new LinkedList<File>();
        int seriesNumber = 1;
        DecimalFormat fmt = new DecimalFormat("00000");
        String predecessorFilename = fileName + fmt.format(seriesNumber);
        while (new File(predecessorFilename).exists()) {
            filenames.add(new File(predecessorFilename));
            predecessorFilename = fileName + fmt.format(++seriesNumber);
        }
        filenames.add(new File(fileName));
        return new CompositeFileReader(filenames);
    }
}

