/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.crawler.datamodel.UriUniqFilter;
import org.archive.modules.CrawlURI;

public abstract class SetBasedUriUniqFilter
implements UriUniqFilter,
Serializable {
    private static Logger LOGGER = Logger.getLogger(SetBasedUriUniqFilter.class.getName());
    protected UriUniqFilter.CrawlUriReceiver receiver;
    protected PrintWriter profileLog;
    protected long duplicateCount = 0L;
    protected long duplicatesAtLastSample = 0L;
    protected AtomicLong addedCount = new AtomicLong();

    public SetBasedUriUniqFilter() {
        String profileLogFile = System.getProperty(SetBasedUriUniqFilter.class.getName() + ".profileLogFile");
        if (profileLogFile != null) {
            this.setProfileLog(new File(profileLogFile));
        }
    }

    protected abstract boolean setAdd(CharSequence var1);

    protected abstract boolean setRemove(CharSequence var1);

    protected abstract long setCount();

    @Override
    public long addedCount() {
        return this.addedCount.get();
    }

    @Override
    public long count() {
        return this.setCount();
    }

    @Override
    public long pending() {
        return 0L;
    }

    @Override
    public void setDestination(UriUniqFilter.CrawlUriReceiver receiver) {
        this.receiver = receiver;
    }

    protected void profileLog(String key) {
        if (this.profileLog != null) {
            this.profileLog.println(key);
        }
    }

    @Override
    public void add(String key, CrawlURI value) {
        this.addedCount.incrementAndGet();
        this.profileLog(key);
        if (this.setAdd(key)) {
            this.receiver.receive(value);
            if (this.setCount() % 50000L == 0L) {
                LOGGER.log(Level.FINE, "count: " + this.setCount() + " totalDups: " + this.duplicateCount + " recentDups: " + (this.duplicateCount - this.duplicatesAtLastSample));
                this.duplicatesAtLastSample = this.duplicateCount;
            }
        } else {
            ++this.duplicateCount;
        }
    }

    @Override
    public void addNow(String key, CrawlURI value) {
        this.add(key, value);
    }

    @Override
    public void addForce(String key, CrawlURI value) {
        this.profileLog(key);
        this.setAdd(key);
        this.receiver.receive(value);
    }

    @Override
    public void note(String key) {
        this.profileLog(key);
        this.setAdd(key);
    }

    @Override
    public void forget(String key, CrawlURI value) {
        this.setRemove(key);
    }

    @Override
    public long requestFlush() {
        return 0L;
    }

    @Override
    public void close() {
        if (this.profileLog != null) {
            this.profileLog.close();
        }
    }

    @Override
    public void setProfileLog(File logfile) {
        try {
            this.profileLog = new PrintWriter(new BufferedOutputStream(new FileOutputStream(logfile)));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

