/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.util;

import java.util.Comparator;
import java.util.Map;
import org.archive.io.warc.WARCWriter;
import org.archive.modules.CoreAttributeConstants;
import org.archive.modules.CrawlURI;
import org.archive.modules.revisit.IdenticalPayloadDigestRevisit;
import org.archive.modules.revisit.ServerNotModifiedRevisit;
import org.archive.util.ArchiveUtils;
import org.archive.util.Histotable;

public class CrawledBytesHistotable
extends Histotable<String>
implements CoreAttributeConstants {
    private static final long serialVersionUID = 7923431123239026213L;
    public static final String NOTMODIFIED = "notModified";
    public static final String DUPLICATE = "dupByHash";
    public static final String OTHERDUPLICATE = "otherDup";
    public static final String NOVEL = "novel";
    public static final String NOTMODIFIEDCOUNT = "notModifiedCount";
    public static final String DUPLICATECOUNT = "dupByHashCount";
    public static final String OTHERDUPLICATECOUNT = "otherDupCount";
    public static final String NOVELCOUNT = "novelCount";
    public static final String WARC_NOVEL_CONTENT_BYTES = "warcNovelContentBytes";
    public static final String WARC_NOVEL_URLS = "warcNovelUrls";

    public CrawledBytesHistotable() {
    }

    protected CrawledBytesHistotable(Comparator<String> comparator) {
        super(comparator);
    }

    public void accumulate(CrawlURI curi) {
        if (curi.getRevisitProfile() instanceof ServerNotModifiedRevisit) {
            this.tally(NOTMODIFIED, curi.getContentSize());
            this.tally(NOTMODIFIEDCOUNT, 1L);
        } else if (curi.getRevisitProfile() instanceof IdenticalPayloadDigestRevisit) {
            this.tally(DUPLICATE, curi.getContentSize());
            this.tally(DUPLICATECOUNT, 1L);
        } else if (curi.getRevisitProfile() != null) {
            this.tally(OTHERDUPLICATE, curi.getContentSize());
            this.tally(OTHERDUPLICATECOUNT, 1L);
        } else {
            this.tally(NOVEL, curi.getContentSize());
            this.tally(NOVELCOUNT, 1L);
        }
        Map warcStats = (Map)curi.getData().get("warc-stats");
        if (warcStats != null) {
            this.tally(WARC_NOVEL_CONTENT_BYTES, WARCWriter.getStat((Map)warcStats, (String)"response", (String)"contentBytes") + WARCWriter.getStat((Map)warcStats, (String)"resource", (String)"contentBytes"));
            this.tally(WARC_NOVEL_URLS, WARCWriter.getStat((Map)warcStats, (String)"response", (String)"numRecords") + WARCWriter.getStat((Map)warcStats, (String)"resource", (String)"numRecords"));
        }
    }

    public String summary() {
        StringBuilder sb = new StringBuilder();
        sb.append(ArchiveUtils.formatBytesForDisplay((long)this.getTotalBytes()));
        sb.append(" crawled (");
        sb.append(ArchiveUtils.formatBytesForDisplay((long)this.get(NOVEL)));
        sb.append(" novel");
        if (this.get(DUPLICATE) != null) {
            sb.append(", ");
            sb.append(ArchiveUtils.formatBytesForDisplay((long)this.get(DUPLICATE)));
            sb.append(" ");
            sb.append(DUPLICATE);
        }
        if (this.get(NOTMODIFIED) != null) {
            sb.append(", ");
            sb.append(ArchiveUtils.formatBytesForDisplay((long)this.get(NOTMODIFIED)));
            sb.append(" ");
            sb.append(NOTMODIFIED);
        }
        if (this.get(OTHERDUPLICATE) != null) {
            sb.append(", ");
            sb.append(ArchiveUtils.formatBytesForDisplay((long)this.get(OTHERDUPLICATE)));
            sb.append(" ");
            sb.append(OTHERDUPLICATECOUNT);
        }
        sb.append(")");
        return sb.toString();
    }

    public long getTotalBytes() {
        return this.get(NOVEL) + this.get(DUPLICATE) + this.get(NOTMODIFIED) + this.get(OTHERDUPLICATE);
    }

    public long getTotalUrls() {
        return this.get(NOVELCOUNT) + this.get(DUPLICATECOUNT) + this.get(NOTMODIFIEDCOUNT) + this.get(OTHERDUPLICATECOUNT);
    }
}

