/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.archive.modules.fetcher.UserAgentProvider;
import org.archive.modules.net.RobotsPolicy;
import org.archive.spring.BeanFieldsPatternValidator;
import org.archive.spring.HasKeyedProperties;
import org.archive.spring.HasValidator;
import org.archive.spring.KeyedProperties;
import org.archive.util.ArchiveUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.Validator;

public class CrawlMetadata
implements UserAgentProvider,
Serializable,
HasKeyedProperties,
HasValidator,
InitializingBean {
    private static final long serialVersionUID = 1L;
    protected KeyedProperties kp = new KeyedProperties();
    protected Map<String, RobotsPolicy> availableRobotsPolicies;
    protected String operator;
    protected String description;
    protected String audience;
    protected String organization;
    protected String jobName;
    protected static Validator VALIDATOR = new BeanFieldsPatternValidator(CrawlMetadata.class, new String[]{"userAgentTemplate", "^.*@OPERATOR_CONTACT_URL@.*$", "You must supply a userAgentTemplate value that includes the string \"@OPERATOR_CONTACT_URL@\" where your crawlcontact URL will appear.", "operatorContactUrl", "^https?://.*$", "You must supply an HTTP(S) URL which will be included in your user-agent and should explain the purpose of your crawl and how to contact the crawl operator in the event of webmaster issues.", "operatorFrom", "^(\\s*|\\S+@[-\\w]+\\.[-\\w\\.]+)|()$", "If not blank, operatorFrom must be an email address."});

    public CrawlMetadata() {
        this.setRobotsPolicyName("obey");
        this.availableRobotsPolicies = new HashMap<String, RobotsPolicy>();
        this.operator = "";
        this.description = "";
        this.setUserAgentTemplate("Mozilla/5.0 (compatible; heritrix/@VERSION@ +@OPERATOR_CONTACT_URL@)");
        this.setOperatorFrom("");
        this.kp.put((Object)"operatorContactUrl", (Object)"ENTER-A-CONTACT-HTTP-URL-FOR-CRAWL-OPERATOR");
        this.audience = "";
        this.organization = "";
    }

    public KeyedProperties getKeyedProperties() {
        return this.kp;
    }

    public String getRobotsPolicyName() {
        return (String)this.kp.get("robotsPolicyName");
    }

    @Autowired(required=false)
    public void setRobotsPolicyName(String policy) {
        this.kp.put((Object)"robotsPolicyName", (Object)policy);
    }

    public Map<String, RobotsPolicy> getAvailableRobotsPolicies() {
        return this.availableRobotsPolicies;
    }

    @Autowired(required=false)
    public void setAvailableRobotsPolicies(Map<String, RobotsPolicy> policies) {
        this.availableRobotsPolicies = policies;
        this.ensureStandardPoliciesAvailable();
    }

    protected void ensureStandardPoliciesAvailable() {
        this.availableRobotsPolicies.putAll(RobotsPolicy.STANDARD_POLICIES);
    }

    public RobotsPolicy getRobotsPolicy() {
        return this.availableRobotsPolicies.get(this.getRobotsPolicyName());
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operatorName) {
        this.operator = operatorName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUserAgentTemplate() {
        return (String)this.kp.get("userAgentTemplate");
    }

    public void setUserAgentTemplate(String template) {
        this.kp.put((Object)"userAgentTemplate", (Object)template);
    }

    public String getOperatorFrom() {
        return (String)this.kp.get("operatorFrom");
    }

    public void setOperatorFrom(String operatorFrom) {
        this.kp.put((Object)"operatorFrom", (Object)operatorFrom);
    }

    public String getOperatorContactUrl() {
        return (String)this.kp.get("operatorContactUrl");
    }

    public void setOperatorContactUrl(String operatorContactUrl) {
        this.kp.put((Object)"operatorContactUrl", (Object)operatorContactUrl);
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    @Override
    public String getUserAgent() {
        String userAgent = this.getUserAgentTemplate();
        String contactURL = this.getOperatorContactUrl();
        userAgent = userAgent.replaceFirst("@OPERATOR_CONTACT_URL@", contactURL);
        userAgent = userAgent.replaceFirst("@VERSION@", Matcher.quoteReplacement(ArchiveUtils.VERSION));
        return userAgent;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    @Override
    public String getFrom() {
        return this.getOperatorFrom();
    }

    public void afterPropertiesSet() {
        this.setOperatorContactUrl(this.getOperatorContactUrl());
        this.ensureStandardPoliciesAvailable();
    }

    public Validator getValidator() {
        return VALIDATOR;
    }
}

