/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang.StringUtils;
import org.archive.bdb.AutoKryo;
import org.archive.modules.credential.Credential;
import org.archive.modules.credential.HtmlFormCredential;
import org.archive.modules.credential.HttpAuthenticationCredential;
import org.archive.modules.extractor.HTMLLinkContext;
import org.archive.modules.extractor.Hop;
import org.archive.modules.extractor.LinkContext;
import org.archive.modules.revisit.RevisitProfile;
import org.archive.net.UURI;
import org.archive.net.UURIFactory;
import org.archive.spring.OverlayContext;
import org.archive.spring.OverlayMapsSource;
import org.archive.util.Base32;
import org.archive.util.Recorder;
import org.archive.util.ReportUtils;
import org.archive.util.Reporter;
import org.json.JSONException;
import org.json.JSONObject;

public class CrawlURI
implements Reporter,
Serializable,
OverlayContext,
Comparable<CrawlURI> {
    private static final long serialVersionUID = 4L;
    private static final Logger logger = Logger.getLogger(CrawlURI.class.getName());
    public static final int UNCALCULATED = -1;
    public static final String A_FETCH_HISTORY = "fetch-history";
    private UURI uuri;
    private boolean isSeed = false;
    private String pathFromSeed;
    private UURI via;
    private LinkContext viaContext;
    private int schedulingDirective = 3;
    private String classKey;
    private int precedence;
    private int fetchStatus = 0;
    private int deferrals = 0;
    private int fetchAttempts = 0;
    private transient int threadNumber;
    private String userAgent = null;
    private transient boolean linkExtractorFinished = false;
    private transient int discardedOutlinks = 0;
    private long contentSize = -1L;
    private long contentLength = -1L;
    protected Map<String, Object> data;
    private boolean forceRevisit = false;
    private transient Recorder httpRecorder = null;
    private String contentType = "unknown";
    private boolean prerequisite = false;
    private FetchType fetchType = FetchType.UNKNOWN;
    protected long ordinal;
    private static final int MAX_HOPS_DISPLAYED = 50;
    private byte[] contentDigest = null;
    private String contentDigestScheme = null;
    private transient RevisitProfile revisitProfile = null;
    protected transient Object holder;
    protected transient Object holderKey;
    protected int holderCost = -1;
    protected transient Collection<CrawlURI> outLinks;
    protected transient ArrayList<String> overlayNames = null;
    protected transient OverlayMapsSource overlayMapsSource;
    protected String canonicalString;
    protected long politenessDelay = -1L;
    protected transient CrawlURI fullVia;
    protected long rescheduleTime = -1L;
    protected JSONObject extraInfo;

    public CrawlURI(UURI uuri) {
        this.uuri = uuri;
        this.pathFromSeed = "";
    }

    public static CrawlURI fromHopsViaString(String uriHopsViaContext) throws URIException {
        String[] args = uriHopsViaContext.split("\\s+");
        UURI u = UURIFactory.getInstance((String)args[0]);
        String pathFromSeed = args.length > 1 ? args[1].toString() : "";
        UURI via = args.length > 2 && args[2].length() > 1 ? UURIFactory.getInstance((String)args[2].toString()) : null;
        HTMLLinkContext viaContext = args.length > 3 && args[2].length() > 1 ? HTMLLinkContext.get(args[3].toString()) : null;
        CrawlURI caUri = new CrawlURI(u, pathFromSeed, via, viaContext);
        return caUri;
    }

    public CrawlURI(UURI u, String pathFromSeed, UURI via, LinkContext viaContext) {
        this.uuri = u;
        this.pathFromSeed = pathFromSeed != null ? pathFromSeed : "";
        this.via = via;
        this.viaContext = viaContext;
    }

    public int getSchedulingDirective() {
        return this.schedulingDirective;
    }

    public void setSchedulingDirective(int priority) {
        this.schedulingDirective = priority;
    }

    public boolean containsDataKey(String key) {
        if (this.data == null) {
            return false;
        }
        return this.data.containsKey(key);
    }

    public static String fetchStatusCodesToString(int code) {
        switch (code) {
            case 1: {
                return "DNS-1-OK";
            }
            case 100: {
                return "HTTP-100-Info-Continue";
            }
            case 101: {
                return "HTTP-101-Info-Switching Protocols";
            }
            case 200: {
                return "HTTP-200-Success-OK";
            }
            case 201: {
                return "HTTP-201-Success-Created";
            }
            case 202: {
                return "HTTP-202-Success-Accepted";
            }
            case 203: {
                return "HTTP-203-Success-Non-Authoritative";
            }
            case 204: {
                return "HTTP-204-Success-No Content ";
            }
            case 205: {
                return "HTTP-205-Success-Reset Content";
            }
            case 206: {
                return "HTTP-206-Success-Partial Content";
            }
            case 300: {
                return "HTTP-300-Redirect-Multiple Choices";
            }
            case 301: {
                return "HTTP-301-Redirect-Moved Permanently";
            }
            case 302: {
                return "HTTP-302-Redirect-Found";
            }
            case 303: {
                return "HTTP-303-Redirect-See Other";
            }
            case 304: {
                return "HTTP-304-Redirect-Not Modified";
            }
            case 305: {
                return "HTTP-305-Redirect-Use Proxy";
            }
            case 307: {
                return "HTTP-307-Redirect-Temporary Redirect";
            }
            case 400: {
                return "HTTP-400-ClientErr-Bad Request";
            }
            case 401: {
                return "HTTP-401-ClientErr-Unauthorized";
            }
            case 402: {
                return "HTTP-402-ClientErr-Payment Required";
            }
            case 403: {
                return "HTTP-403-ClientErr-Forbidden";
            }
            case 404: {
                return "HTTP-404-ClientErr-Not Found";
            }
            case 405: {
                return "HTTP-405-ClientErr-Method Not Allowed";
            }
            case 407: {
                return "HTTP-406-ClientErr-Not Acceptable";
            }
            case 408: {
                return "HTTP-407-ClientErr-Proxy Authentication Required";
            }
            case 409: {
                return "HTTP-408-ClientErr-Request Timeout";
            }
            case 410: {
                return "HTTP-409-ClientErr-Conflict";
            }
            case 406: {
                return "HTTP-410-ClientErr-Gone";
            }
            case 411: {
                return "HTTP-411-ClientErr-Length Required";
            }
            case 412: {
                return "HTTP-412-ClientErr-Precondition Failed";
            }
            case 413: {
                return "HTTP-413-ClientErr-Request Entity Too Large";
            }
            case 414: {
                return "HTTP-414-ClientErr-Request-URI Too Long";
            }
            case 415: {
                return "HTTP-415-ClientErr-Unsupported Media Type";
            }
            case 416: {
                return "HTTP-416-ClientErr-Requested Range Not Satisfiable";
            }
            case 417: {
                return "HTTP-417-ClientErr-Expectation Failed";
            }
            case 500: {
                return "HTTP-500-ServerErr-Internal Server Error";
            }
            case 501: {
                return "HTTP-501-ServerErr-Not Implemented";
            }
            case 502: {
                return "HTTP-502-ServerErr-Bad Gateway";
            }
            case 503: {
                return "HTTP-503-ServerErr-Service Unavailable";
            }
            case 504: {
                return "HTTP-504-ServerErr-Gateway Timeout";
            }
            case 505: {
                return "HTTP-505-ServerErr-HTTP Version Not Supported";
            }
            case -5001: {
                return "Heritrix(-5001)-Blocked by user";
            }
            case -5002: {
                return "Heritrix(-5002)-Blocked by custom prefetch processor";
            }
            case -6000: {
                return "Heritrix(-6000)-Deleted by user";
            }
            case -2: {
                return "Heritrix(-2)-Connection failed";
            }
            case -3: {
                return "Heritrix(-3)-Connection lost";
            }
            case -4000: {
                return "Heritrix(-4000)-Deemed chaff";
            }
            case -50: {
                return "Heritrix(-50)-Deferred";
            }
            case -1: {
                return "Heritrix(-1)-Domain unresolvable";
            }
            case -5000: {
                return "Heritrix(-5000)-Out of scope";
            }
            case -6: {
                return "Heritrix(-6)-Domain prerequisite failure";
            }
            case -61: {
                return "Heritrix(-61)-Robots prerequisite failure";
            }
            case -62: {
                return "Heritrix(-62)-Other prerequisite failure";
            }
            case -63: {
                return "Heritrix(-63)-Prerequisite unschedulable failure";
            }
            case -9998: {
                return "Heritrix(-9998)-Robots precluded";
            }
            case -5: {
                return "Heritrix(-5)-Runtime exception";
            }
            case -3000: {
                return "Heritrix(-3000)-Serious error";
            }
            case -4: {
                return "Heritrix(-4)-Timeout";
            }
            case -4002: {
                return "Heritrix(-4002)-Too many embed hops";
            }
            case -4001: {
                return "Heritrix(-4001)-Too many link hops";
            }
            case -8: {
                return "Heritrix(-8)-Too many retries";
            }
            case 0: {
                return "Heritrix(0)-Unattempted";
            }
            case -7: {
                return "Heritrix(-7)-Unfetchable URI";
            }
            case -7000: {
                return "Heritrix(-7000)-Processing thread killed";
            }
        }
        return Integer.toString(code);
    }

    public int getFetchStatus() {
        return this.fetchStatus;
    }

    public void setFetchStatus(int newstatus) {
        this.fetchStatus = newstatus;
    }

    public int getFetchAttempts() {
        return this.fetchAttempts;
    }

    public void incrementFetchAttempts() {
        ++this.fetchAttempts;
    }

    public void resetFetchAttempts() {
        this.fetchAttempts = 0;
    }

    public void resetDeferrals() {
        this.deferrals = 0;
    }

    public void setPrerequisiteUri(CrawlURI pre) {
        this.getData().put("prerequisite-uri", pre);
    }

    public CrawlURI getPrerequisiteUri() {
        return (CrawlURI)this.getData().get("prerequisite-uri");
    }

    public CrawlURI clearPrerequisiteUri() {
        return (CrawlURI)this.getData().remove("prerequisite-uri");
    }

    public boolean hasPrerequisiteUri() {
        return this.containsDataKey("prerequisite-uri");
    }

    public boolean isPrerequisite() {
        return this.prerequisite;
    }

    public void setPrerequisite(boolean prerequisite) {
        this.prerequisite = prerequisite;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String ct) {
        if (ct == null) {
            ct = "unknown";
        }
        this.contentType = ct;
    }

    public void setThreadNumber(int i) {
        this.threadNumber = i;
    }

    public int getThreadNumber() {
        return this.threadNumber;
    }

    public void incrementDeferrals() {
        ++this.deferrals;
    }

    public int getDeferrals() {
        return this.deferrals;
    }

    public void stripToMinimal() {
        this.data = null;
    }

    public long getContentSize() {
        return this.contentSize;
    }

    public Collection<String> getAnnotations() {
        LinkedHashSet annotations = (LinkedHashSet)this.getData().get("annotations");
        if (annotations == null) {
            annotations = new LinkedHashSet();
            this.getData().put("annotations", annotations);
        }
        return annotations;
    }

    public int getHopCount() {
        if (this.pathFromSeed.length() <= 50) {
            return this.pathFromSeed.length();
        }
        int plusIndex = this.pathFromSeed.indexOf(43);
        if (plusIndex < 0) {
            return this.pathFromSeed.length();
        }
        return Integer.parseInt(this.pathFromSeed.substring(0, plusIndex)) + this.pathFromSeed.length() - (plusIndex + 1);
    }

    public int getEmbedHopCount() {
        int embedHops = 0;
        for (int i = this.pathFromSeed.length() - 1; i >= 0 && this.pathFromSeed.charAt(i) != Hop.NAVLINK.getHopChar(); --i) {
            ++embedHops;
        }
        return embedHops;
    }

    public int getLinkHopCount() {
        int linkHops = 0;
        for (int i = this.pathFromSeed.length() - 1; i >= 0; --i) {
            if (this.pathFromSeed.charAt(i) != Hop.NAVLINK.getHopChar()) continue;
            ++linkHops;
        }
        return linkHops;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public long getContentLength() {
        if (this.contentLength < 0L) {
            this.contentLength = this.getRecorder() != null ? this.getRecorder().getResponseContentLength() : 0L;
        }
        return this.contentLength;
    }

    public long getRecordedSize() {
        return this.getRecorder() != null ? this.getRecorder().getRecordedInput().getSize() : this.getContentSize();
    }

    public void setContentSize(long l) {
        this.contentSize = l;
    }

    public boolean hasBeenLinkExtracted() {
        return this.linkExtractorFinished;
    }

    public void linkExtractorFinished() {
        this.linkExtractorFinished = true;
        if (this.discardedOutlinks > 0) {
            this.getAnnotations().add("dol:" + this.discardedOutlinks);
        }
    }

    public void aboutToLog() {
        if (this.fetchAttempts > 1) {
            this.getAnnotations().add(this.fetchAttempts + "t");
        }
    }

    public Recorder getRecorder() {
        return this.httpRecorder;
    }

    public void setRecorder(Recorder httpRecorder) {
        this.httpRecorder = httpRecorder;
    }

    public boolean isHttpTransaction() {
        return this.getFetchType().equals((Object)FetchType.HTTP_GET) || this.getFetchType().equals((Object)FetchType.HTTP_POST);
    }

    public void processingCleanup() {
        this.httpRecorder = null;
        this.fetchStatus = 0;
        this.setPrerequisite(false);
        this.clearPrerequisiteUri();
        this.contentSize = -1L;
        this.contentLength = -1L;
        this.linkExtractorFinished = false;
        this.extraInfo = null;
        this.outLinks = null;
        this.revisitProfile = null;
        this.fetchType = FetchType.UNKNOWN;
    }

    public Set<Credential> getCredentials() {
        HashSet r = (HashSet)this.getData().get("credentials");
        if (r == null) {
            r = new HashSet();
            this.getData().put("credentials", r);
        }
        return r;
    }

    public boolean hasCredentials() {
        return this.containsDataKey("credentials");
    }

    public boolean isSuccess() {
        boolean result = false;
        int statusCode = this.fetchStatus;
        result = statusCode == 401 && this.hasRfc2617Credential() ? false : statusCode > 0;
        return result;
    }

    public boolean is2XXSuccess() {
        return this.fetchStatus >= 200 && this.fetchStatus < 300;
    }

    public boolean hasRfc2617Credential() {
        Set<Credential> credentials = this.getCredentials();
        if (credentials != null && credentials.size() > 0) {
            for (Credential credential : credentials) {
                if (!(credential instanceof HttpAuthenticationCredential)) continue;
                return true;
            }
        }
        return false;
    }

    public void setContentDigest(byte[] digestValue) {
        this.setContentDigest("SHA1", digestValue);
    }

    public void setContentDigest(String scheme, byte[] digestValue) {
        this.contentDigest = digestValue;
        this.contentDigestScheme = scheme;
    }

    public String getContentDigestSchemeString() {
        if (this.contentDigest == null) {
            return null;
        }
        return this.contentDigestScheme + ":" + this.getContentDigestString();
    }

    public byte[] getContentDigest() {
        return this.contentDigest;
    }

    public String getContentDigestString() {
        if (this.contentDigest == null) {
            return null;
        }
        return Base32.encode((byte[])this.contentDigest);
    }

    public void setHolder(Object obj) {
        this.holder = obj;
    }

    public Object getHolder() {
        return this.holder;
    }

    public void setHolderKey(Object obj) {
        this.holderKey = obj;
    }

    public Object getHolderKey() {
        return this.holderKey;
    }

    public long getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(long o) {
        this.ordinal = o;
    }

    public int getHolderCost() {
        return this.holderCost;
    }

    public void setHolderCost(int cost) {
        this.holderCost = cost;
    }

    public Collection<CrawlURI> getOutLinks() {
        if (this.outLinks == null) {
            this.outLinks = new LinkedHashSet<CrawlURI>();
        }
        return this.outLinks;
    }

    public void setBaseURI(String baseHref) throws URIException {
        this.getData().put("html-base-href", UURIFactory.getInstance((String)baseHref));
    }

    public UURI getBaseURI() {
        if (!this.containsDataKey("html-base-href")) {
            return this.getUURI();
        }
        return (UURI)this.getData().get("html-base-href");
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(this.data == null || this.data.isEmpty() ? null : this.data);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        Map temp;
        stream.defaultReadObject();
        this.data = temp = (Map)stream.readObject();
    }

    protected UURI readUuri(String u) {
        if (u == null) {
            return null;
        }
        try {
            return UURIFactory.getInstance((String)u);
        }
        catch (URIException uRIException) {
            try {
                return UURIFactory.getInstance((String)("invalid:" + u));
            }
            catch (URIException ux) {
                ux.printStackTrace();
                try {
                    return UURIFactory.getInstance((String)"invalid:");
                }
                catch (URIException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
    }

    public String getServerIP() {
        if (this.data == null) {
            return null;
        }
        return (String)this.data.get("server-ip");
    }

    public long getFetchBeginTime() {
        if (this.containsDataKey("fetch-began-time")) {
            return (Long)this.getData().get("fetch-began-time");
        }
        return 1L;
    }

    public long getFetchCompletedTime() {
        if (this.containsDataKey("fetch-completed-time")) {
            return (Long)this.getData().get("fetch-completed-time");
        }
        return 0L;
    }

    public long getFetchDuration() {
        if (!this.containsDataKey("fetch-completed-time")) {
            return -1L;
        }
        long completedTime = this.getFetchCompletedTime();
        long beganTime = this.getFetchBeginTime();
        return completedTime - beganTime;
    }

    public FetchType getFetchType() {
        return this.fetchType;
    }

    public Collection<Throwable> getNonFatalFailures() {
        ArrayList list = (ArrayList)this.getData().get("nonfatal-errors");
        if (list == null) {
            list = new ArrayList();
            this.getData().put("nonfatal-errors", list);
        }
        return list;
    }

    public void setServerIP(String serverIP) {
        this.getData().put("server-ip", serverIP);
    }

    public void setError(String msg) {
        this.getData().put("error", msg);
    }

    public void setFetchBeginTime(long time) {
        this.getData().put("fetch-began-time", time);
    }

    public void setFetchCompletedTime(long time) {
        this.getData().put("fetch-completed-time", time);
    }

    public void setFetchType(FetchType type) {
        this.fetchType = type;
    }

    public void setForceRetire(boolean b) {
        this.getData().put("force-retire", b);
    }

    public void setBaseURI(UURI base) {
        this.getData().put("html-base-href", base);
    }

    public Map<String, Object> getData() {
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
        return this.data;
    }

    public List<Object> getDataList(String key) {
        if (!this.containsDataKey(key)) {
            this.getData().put(key, new ArrayList());
        }
        return (List)this.getData().get(key);
    }

    public void setSeed(boolean b) {
        this.isSeed = b;
        if (this.isSeed && this.pathFromSeed == null) {
            this.pathFromSeed = "";
        }
    }

    public boolean isSeed() {
        return this.isSeed;
    }

    public UURI getUURI() {
        return this.uuri;
    }

    public String getURI() {
        return this.getUURI().toCustomString();
    }

    public String getPathFromSeed() {
        return this.pathFromSeed;
    }

    public String getLastHop() {
        return StringUtils.isEmpty((String)this.pathFromSeed) ? "" : this.pathFromSeed.substring(this.pathFromSeed.length() - 1);
    }

    public UURI getVia() {
        return this.via;
    }

    public void setVia(UURI via) {
        this.via = via;
    }

    public LinkContext getViaContext() {
        return this.viaContext;
    }

    public boolean isLocation() {
        return this.pathFromSeed != null && this.pathFromSeed.length() > 0 && this.pathFromSeed.charAt(this.pathFromSeed.length() - 1) == Hop.REFER.getHopChar();
    }

    public String shortReportLine() {
        return ReportUtils.shortReportLine((Reporter)this);
    }

    public Map<String, Object> shortReportMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("class", this.getClass().getName());
        map.put("uri", this.getUURI().toString());
        map.put("pathFromSeed", this.pathFromSeed);
        map.put("flattenVia", this.flattenVia());
        return map;
    }

    public void shortReportLineTo(PrintWriter w) {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(".") + 1);
        w.print(className);
        w.print(" ");
        w.print(this.getUURI().toString());
        w.print(" ");
        w.print(this.pathFromSeed);
        w.print(" ");
        w.print(this.flattenVia());
    }

    public String shortReportLegend() {
        return "className uri hopsPath viaUri";
    }

    public void reportTo(PrintWriter writer) throws IOException {
        this.shortReportLineTo(writer);
        writer.print("\n");
    }

    public String flattenVia() {
        return this.via == null ? "" : this.via.toString();
    }

    public String getSourceTag() {
        return (String)this.getData().get("source");
    }

    public void setSourceTag(String sourceTag) {
        this.getData().put("source", sourceTag);
        this.makeHeritable("source");
    }

    public void makeHeritable(String key) {
        HashSet<String> heritableKeys = (HashSet<String>)this.data.get("heritable");
        if (heritableKeys == null) {
            heritableKeys = new HashSet<String>();
            heritableKeys.add("heritable");
            this.data.put("heritable", heritableKeys);
        }
        heritableKeys.add(key);
    }

    public void makeNonHeritable(String key) {
        HashSet heritableKeys = (HashSet)this.data.get("heritable");
        if (heritableKeys == null) {
            return;
        }
        heritableKeys.remove(key);
        if (heritableKeys.size() == 1) {
            this.data.remove("heritable");
        }
    }

    public String getClassKey() {
        return this.classKey;
    }

    public void setClassKey(String key) {
        this.classKey = key;
    }

    public boolean forceFetch() {
        return this.forceRevisit;
    }

    public void setForceFetch(boolean b) {
        this.forceRevisit = b;
    }

    public int getTransHops() {
        String path = this.getPathFromSeed();
        int transCount = 0;
        for (int i = path.length() - 1; i >= 0 && path.charAt(i) != Hop.NAVLINK.getHopChar(); --i) {
            ++transCount;
        }
        return transCount;
    }

    protected void inheritFrom(CrawlURI ancestor) {
        Map<String, Object> adata = ancestor.getData();
        HashSet heritableKeys = (HashSet)adata.get("heritable");
        Map<String, Object> thisData = this.getData();
        if (heritableKeys != null) {
            for (String key : heritableKeys) {
                thisData.put(key, adata.get(key));
            }
        }
    }

    public CrawlURI createCrawlURI(UURI destination, LinkContext context, Hop hop) throws URIException {
        return this.createCrawlURI(destination.toString(), context, hop);
    }

    public CrawlURI createCrawlURI(String destination, LinkContext context, Hop hop) throws URIException {
        UURI u = UURIFactory.getInstance((UURI)this.getBaseURI(), (String)destination);
        CrawlURI newCaURI = new CrawlURI(u, CrawlURI.extendHopsPath(this.getPathFromSeed(), hop.getHopChar()), this.getUURI(), context);
        newCaURI.inheritFrom(this);
        return newCaURI;
    }

    public static String extendHopsPath(String pathFromSeed, char hopChar) {
        if (pathFromSeed.length() < 50) {
            return pathFromSeed + hopChar;
        }
        int plusIndex = pathFromSeed.indexOf(43);
        int prevOverflow = plusIndex < 0 ? 0 : Integer.parseInt(pathFromSeed.substring(0, plusIndex));
        return prevOverflow + 1 + "+" + pathFromSeed.substring(plusIndex + 2) + hopChar;
    }

    public CrawlURI createCrawlURI(UURI destination, LinkContext context, Hop hop, int scheduling, boolean seed) throws URIException {
        CrawlURI caURI = this.createCrawlURI(destination, context, hop);
        caURI.setSchedulingDirective(scheduling);
        caURI.setSeed(seed);
        return caURI;
    }

    public String toString() {
        return this.getUURI().toCustomString();
    }

    public void incrementDiscardedOutLinks() {
        ++this.discardedOutlinks;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public void setPrecedence(int precedence) {
        this.precedence = precedence;
    }

    public UURI getPolicyBasisUURI() {
        UURI effectiveuuri = null;
        if (this.getPathFromSeed().endsWith(Hop.PREREQ.getHopString())) {
            effectiveuuri = this.getVia();
        }
        if (effectiveuuri == null) {
            effectiveuuri = this.getUURI();
        }
        return effectiveuuri;
    }

    public boolean haveOverlayNamesBeenSet() {
        return this.overlayNames != null;
    }

    public ArrayList<String> getOverlayNames() {
        if (this.overlayNames == null) {
            this.overlayNames = new ArrayList();
        }
        return this.overlayNames;
    }

    public Map<String, Object> getOverlayMap(String name) {
        return this.overlayMapsSource.getOverlayMap(name);
    }

    public void setOverlayMapsSource(OverlayMapsSource overrideMapsSource) {
        this.overlayMapsSource = overrideMapsSource;
    }

    public void setCanonicalString(String canonical) {
        this.canonicalString = canonical;
    }

    public String getCanonicalString() {
        if (StringUtils.isEmpty((String)this.canonicalString)) {
            logger.warning("canonicalString unset, returning uncanonicalized " + this.getURI());
            return this.getURI();
        }
        return this.canonicalString;
    }

    public void setPolitenessDelay(long polite) {
        this.politenessDelay = polite;
    }

    public long getPolitenessDelay() {
        if (this.politenessDelay < 0L) {
            logger.warning("politessDelay unset, returning default 5000 for " + this);
            return 5000L;
        }
        return this.politenessDelay;
    }

    public void setFullVia(CrawlURI curi) {
        this.fullVia = curi;
    }

    public CrawlURI getFullVia() {
        return this.fullVia;
    }

    public void setRescheduleTime(long time) {
        this.rescheduleTime = time;
    }

    public long getRescheduleTime() {
        return this.rescheduleTime;
    }

    public void resetForRescheduling() {
        this.resetFetchAttempts();
        this.resetDeferrals();
    }

    public boolean includesRetireDirective() {
        return this.containsDataKey("force-retire") && (Boolean)this.getData().get("force-retire") != false;
    }

    public JSONObject getExtraInfo() {
        if (this.extraInfo == null) {
            this.extraInfo = new JSONObject();
        }
        return this.extraInfo;
    }

    public void addExtraInfo(String key, Object value) {
        try {
            this.getExtraInfo().put(key, value);
        }
        catch (JSONException e) {
            logger.log(Level.WARNING, "failed to add extra info", e);
        }
    }

    private CrawlURI() {
    }

    public static void autoregisterTo(AutoKryo kryo) {
        kryo.register(CrawlURI.class);
        kryo.autoregister(byte[].class);
        kryo.autoregister(HashSet.class);
        kryo.autoregister(HashMap.class);
        kryo.autoregister(UURI.class);
        kryo.autoregister(HTMLLinkContext.class);
        kryo.autoregister(LinkContext.SimpleLinkContext.class);
        kryo.autoregister(HashMap[].class);
        kryo.autoregister(HttpAuthenticationCredential.class);
        kryo.autoregister(HtmlFormCredential.class);
        kryo.autoregister(NameValuePair.class);
        kryo.autoregister(NameValuePair[].class);
        kryo.autoregister(FetchType.class);
    }

    public CrawlURI markPrerequisite(String preq) throws URIException {
        CrawlURI caUri = this.createCrawlURI(preq, LinkContext.PREREQ_MISC, Hop.PREREQ);
        caUri.setPrerequisite(true);
        int prereqPriority = this.getSchedulingDirective() - 1;
        if (prereqPriority < 0) {
            prereqPriority = 0;
            logger.severe("Unable to promote prerequisite " + caUri + " above " + this);
        }
        caUri.setSchedulingDirective(prereqPriority);
        caUri.setForceFetch(true);
        this.setPrerequisiteUri(caUri);
        this.incrementDeferrals();
        this.setFetchStatus(-50);
        return caUri;
    }

    public boolean containsContentTypeCharsetDeclaration() {
        return this.getContentType().matches("(?i).*charset=.*");
    }

    public String getHttpResponseHeader(String key) {
        Map httpResponseHeaders = (Map)this.getData().get("http-response-headers");
        if (httpResponseHeaders == null) {
            return null;
        }
        return (String)httpResponseHeaders.get(key.toLowerCase());
    }

    public void putHttpResponseHeader(String key, String value) {
        HashMap<String, String> httpResponseHeaders = (HashMap<String, String>)this.getData().get("http-response-headers");
        if (httpResponseHeaders == null) {
            httpResponseHeaders = new HashMap<String, String>();
            this.getData().put("http-response-headers", httpResponseHeaders);
        }
        httpResponseHeaders.put(key.toLowerCase(), value);
    }

    public Map<String, String> getHttpAuthChallenges() {
        return (Map)this.getData().get("http-auth-challenges");
    }

    public void setHttpAuthChallenges(Map<String, String> httpAuthChallenges) {
        this.getData().put("http-auth-challenges", httpAuthChallenges);
    }

    public HashMap<String, Object>[] getFetchHistory() {
        return (HashMap[])this.getData().get(A_FETCH_HISTORY);
    }

    public void setFetchHistory(Map<String, Object>[] history) {
        this.getData().put(A_FETCH_HISTORY, history);
    }

    public HashMap<String, Object> getContentDigestHistory() {
        HashMap contentDigestHistory = (HashMap)this.getData().get("content-digest-history");
        if (contentDigestHistory == null) {
            contentDigestHistory = new HashMap();
            this.getData().put("content-digest-history", contentDigestHistory);
        }
        return contentDigestHistory;
    }

    public boolean hasContentDigestHistory() {
        return this.getData().get("content-digest-history") != null;
    }

    public boolean isRevisit() {
        return this.revisitProfile != null;
    }

    public RevisitProfile getRevisitProfile() {
        return this.revisitProfile;
    }

    public void setRevisitProfile(RevisitProfile revisitProfile) {
        this.revisitProfile = revisitProfile;
    }

    @Override
    public int compareTo(CrawlURI o) {
        int cmp = CrawlURI.compare(this.via.toString(), o.via.toString());
        if (cmp == 0) {
            cmp = CrawlURI.compare(this.uuri.toString(), o.uuri.toString());
        }
        if (cmp == 0) {
            cmp = CrawlURI.compare(this.viaContext.toString(), o.viaContext.toString());
        }
        if (cmp == 0) {
            cmp = CrawlURI.compare(this.pathFromSeed, o.pathFromSeed);
        }
        return cmp;
    }

    public int hashCode() {
        int r = 37;
        String viaString = this.via == null ? "" : this.via.toString();
        String viaContextString = this.viaContext == null ? "" : this.viaContext.toString();
        String pathFromSeedString = this.pathFromSeed == null ? "" : this.pathFromSeed.toString();
        return r ^ CrawlURI.hash(viaString) ^ CrawlURI.hash(this.uuri.toString()) ^ CrawlURI.hash(viaContextString) ^ CrawlURI.hash(pathFromSeedString);
    }

    private static int hash(String a) {
        return a == null ? 0 : a.hashCode();
    }

    private static boolean equals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    private static int compare(String a, String b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null && b != null) {
            return -1;
        }
        if (a != null && b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CrawlURI)) {
            return false;
        }
        CrawlURI u = (CrawlURI)o;
        return CrawlURI.equals(this.via, u.via) && CrawlURI.equals(this.uuri, u.uuri) && CrawlURI.equals(this.viaContext, u.viaContext) && CrawlURI.equals(this.pathFromSeed, u.pathFromSeed);
    }

    public static enum FetchType {
        HTTP_GET,
        HTTP_POST,
        UNKNOWN;

    }
}

