/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.archive.checkpointing.Checkpoint;
import org.archive.checkpointing.Checkpointable;
import org.archive.modules.CrawlURI;
import org.archive.modules.ProcessResult;
import org.archive.modules.credential.Credential;
import org.archive.modules.credential.HttpAuthenticationCredential;
import org.archive.modules.deciderules.AcceptDecideRule;
import org.archive.modules.deciderules.DecideResult;
import org.archive.modules.deciderules.DecideRule;
import org.archive.net.UURI;
import org.archive.spring.HasKeyedProperties;
import org.archive.spring.KeyedProperties;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.Lifecycle;

public abstract class Processor
implements HasKeyedProperties,
Lifecycle,
BeanNameAware,
Checkpointable {
    protected KeyedProperties kp = new KeyedProperties();
    protected String beanName;
    protected AtomicLong uriCount;
    protected boolean isRunning;
    protected Checkpoint recoveryCheckpoint;

    public Processor() {
        this.setEnabled(true);
        this.setShouldProcessRule(new AcceptDecideRule());
        this.uriCount = new AtomicLong(0L);
        this.isRunning = false;
    }

    public KeyedProperties getKeyedProperties() {
        return this.kp;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public boolean getEnabled() {
        return (Boolean)this.kp.get("enabled");
    }

    public void setEnabled(boolean enabled) {
        this.kp.put((Object)"enabled", (Object)enabled);
    }

    public DecideRule getShouldProcessRule() {
        return (DecideRule)this.kp.get("shouldProcessRule");
    }

    public void setShouldProcessRule(DecideRule rule) {
        this.kp.put((Object)"shouldProcessRule", (Object)rule);
    }

    public ProcessResult process(CrawlURI uri) throws InterruptedException {
        if (!this.getEnabled()) {
            return ProcessResult.PROCEED;
        }
        if (this.getShouldProcessRule().decisionFor(uri) == DecideResult.REJECT) {
            this.innerRejectProcess(uri);
            return ProcessResult.PROCEED;
        }
        if (this.shouldProcess(uri)) {
            this.uriCount.incrementAndGet();
            return this.innerProcessResult(uri);
        }
        return ProcessResult.PROCEED;
    }

    public long getURICount() {
        return this.uriCount.get();
    }

    protected abstract boolean shouldProcess(CrawlURI var1);

    protected ProcessResult innerProcessResult(CrawlURI uri) throws InterruptedException {
        this.innerProcess(uri);
        return ProcessResult.PROCEED;
    }

    protected abstract void innerProcess(CrawlURI var1) throws InterruptedException;

    protected void innerRejectProcess(CrawlURI uri) throws InterruptedException {
    }

    public static String flattenVia(CrawlURI puri) {
        UURI uuri = puri.getVia();
        return uuri == null ? "" : uuri.toString();
    }

    public static boolean isSuccess(CrawlURI puri) {
        boolean result = false;
        int statusCode = puri.getFetchStatus();
        result = statusCode == 401 && Processor.hasHttpAuthenticationCredential(puri) ? false : statusCode > 0;
        return result;
    }

    public static long getRecordedSize(CrawlURI puri) {
        if (puri.getRecorder() == null) {
            return puri.getContentSize();
        }
        return puri.getRecorder().getRecordedInput().getSize();
    }

    public static boolean hasHttpAuthenticationCredential(CrawlURI puri) {
        Set<Credential> credentials = puri.getCredentials();
        for (Credential ca : credentials) {
            if (!(ca instanceof HttpAuthenticationCredential)) continue;
            return true;
        }
        return false;
    }

    public String report() {
        return "Processor: " + this.getClass().getName() + "\n";
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        if (this.recoveryCheckpoint != null) {
            try {
                JSONObject json = this.recoveryCheckpoint.loadJson(this.getBeanName());
                this.fromCheckpointJson(json);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void stop() {
        this.isRunning = false;
    }

    public void startCheckpoint(Checkpoint checkpointInProgress) {
    }

    public void doCheckpoint(Checkpoint checkpointInProgress) throws IOException {
        try {
            JSONObject json = this.toCheckpointJson();
            checkpointInProgress.saveJson(this.beanName, json);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    protected JSONObject toCheckpointJson() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("uriCount", this.getURICount());
        return json;
    }

    protected void fromCheckpointJson(JSONObject json) throws JSONException {
        this.uriCount.set(json.getLong("uriCount"));
    }

    public void finishCheckpoint(Checkpoint checkpointInProgress) {
    }

    @Autowired(required=false)
    public void setRecoveryCheckpoint(Checkpoint checkpoint) {
        this.recoveryCheckpoint = checkpoint;
    }
}

