/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.archive.modules.CrawlURI;
import org.archive.modules.ProcessResult;
import org.archive.modules.Processor;
import org.archive.spring.HasKeyedProperties;
import org.archive.spring.KeyedProperties;
import org.archive.spring.OverlayContext;
import org.archive.util.ArchiveUtils;
import org.archive.util.Reporter;
import org.springframework.context.Lifecycle;

public class ProcessorChain
implements Iterable<Processor>,
HasKeyedProperties,
Reporter,
Lifecycle {
    protected KeyedProperties kp = new KeyedProperties();
    protected boolean isRunning = false;

    public KeyedProperties getKeyedProperties() {
        return this.kp;
    }

    public int size() {
        return this.getProcessors().size();
    }

    @Override
    public Iterator<Processor> iterator() {
        return this.getProcessors().iterator();
    }

    public List<Processor> getProcessors() {
        return (List)this.kp.get("processors");
    }

    public void setProcessors(List<Processor> processors) {
        this.kp.put((Object)"processors", processors);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void start() {
        for (Processor p : this.getProcessors()) {
            p.start();
        }
        this.isRunning = true;
    }

    public void stop() {
        for (Processor p : this.getProcessors()) {
            p.stop();
        }
        this.isRunning = false;
    }

    public void reportTo(PrintWriter writer) {
        writer.print(this.getClass().getSimpleName() + " - Processors report - " + ArchiveUtils.get12DigitDate() + "\n");
        writer.print("  Number of Processors: " + this.size() + "\n\n");
        for (Processor p : this) {
            writer.print(p.report());
            writer.println();
        }
        writer.println();
    }

    public String shortReportLegend() {
        return "";
    }

    public Map<String, Object> shortReportMap() {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("processorCount", this.size());
        data.put("processors", this.getProcessors());
        return data;
    }

    public void shortReportLineTo(PrintWriter pw) {
        pw.print(this.size());
        pw.print(" processors: ");
        for (Processor p : this) {
            pw.print(p.getBeanName());
            pw.print(" ");
        }
    }

    public void process(CrawlURI curi, ChainStatusReceiver thread) throws InterruptedException {
        assert (KeyedProperties.overridesActiveFrom((OverlayContext)curi));
        String skipToProc = null;
        block5: for (Processor curProc : this) {
            if (skipToProc != null && !curProc.getBeanName().equals(skipToProc)) continue;
            skipToProc = null;
            if (thread != null) {
                thread.atProcessor(curProc);
            }
            ArchiveUtils.continueCheck();
            ProcessResult pr = curProc.process(curi);
            switch (pr.getProcessStatus()) {
                case PROCEED: {
                    continue block5;
                }
                case FINISH: {
                    break block5;
                }
                case JUMP: {
                    skipToProc = pr.getJumpTarget();
                    continue block5;
                }
                default: {
                    continue block5;
                }
            }
        }
    }

    public static interface ChainStatusReceiver {
        public void atProcessor(Processor var1);
    }
}

