/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules;

import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.archive.io.ReadSource;
import org.archive.modules.CrawlURI;
import org.archive.modules.Processor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ScriptedProcessor
extends Processor
implements ApplicationContextAware,
InitializingBean {
    private static final long serialVersionUID = 3L;
    private static final Logger logger = Logger.getLogger(ScriptedProcessor.class.getName());
    protected String engineName = "beanshell";
    protected ReadSource scriptSource = null;
    protected boolean isolateThreads = true;
    protected ApplicationContext appCtx;
    protected transient ThreadLocal<ScriptEngine> threadEngine = new ThreadLocal();
    protected ScriptEngine sharedEngine;

    public String getEngineName() {
        return this.engineName;
    }

    public void setEngineName(String name) {
        this.engineName = name;
    }

    public ReadSource getScriptSource() {
        return this.scriptSource;
    }

    @Required
    public void setScriptSource(ReadSource source) {
        this.scriptSource = source;
    }

    public boolean getIsolateThreads() {
        return this.isolateThreads;
    }

    public void setIsolateThreads(boolean isolateThreads) {
        this.isolateThreads = isolateThreads;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appCtx = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (null == new ScriptEngineManager().getEngineByName(this.engineName)) {
            throw new BeanInitializationException("named ScriptEngine not available");
        }
    }

    @Override
    protected boolean shouldProcess(CrawlURI curi) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void innerProcess(CrawlURI curi) {
        ScriptEngine engine;
        ScriptEngine scriptEngine = engine = this.getEngine();
        synchronized (scriptEngine) {
            engine.put("curi", curi);
            engine.put("appCtx", this.appCtx);
            try {
                engine.eval("process(curi)");
            }
            catch (ScriptException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
            finally {
                engine.put("curi", null);
                engine.put("appCtx", null);
            }
        }
    }

    protected synchronized ScriptEngine getEngine() {
        if (this.getIsolateThreads()) {
            if (this.threadEngine.get() == null) {
                this.threadEngine.set(this.newEngine());
            }
            return this.threadEngine.get();
        }
        if (this.sharedEngine == null) {
            this.sharedEngine = this.newEngine();
        }
        return this.sharedEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScriptEngine newEngine() {
        ScriptEngine interpreter = new ScriptEngineManager().getEngineByName(this.engineName);
        interpreter.put("self", this);
        interpreter.put("context", this.appCtx);
        Reader reader = null;
        try {
            reader = this.getScriptSource().obtainReader();
            interpreter.eval(reader);
        }
        catch (ScriptException e) {
            logger.log(Level.SEVERE, "script problem", e);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return interpreter;
    }
}

