/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.canonicalize;

import java.io.Serializable;
import java.util.regex.Matcher;
import org.archive.modules.canonicalize.CanonicalizationRule;
import org.archive.spring.HasKeyedProperties;
import org.archive.spring.KeyedProperties;
import org.archive.util.TextUtils;

public abstract class BaseRule
implements CanonicalizationRule,
Serializable,
HasKeyedProperties {
    private static final long serialVersionUID = 1L;
    protected KeyedProperties kp = new KeyedProperties();

    public KeyedProperties getKeyedProperties() {
        return this.kp;
    }

    @Override
    public boolean getEnabled() {
        return (Boolean)this.kp.get("enabled");
    }

    public void setEnabled(boolean enabled) {
        this.kp.put((Object)"enabled", (Object)enabled);
    }

    public BaseRule() {
        this.setEnabled(true);
    }

    protected String doStripRegexMatch(String url, String pat) {
        Matcher matcher = TextUtils.getMatcher((String)pat, (CharSequence)url);
        String retVal = matcher != null && matcher.matches() ? this.checkForNull(matcher.group(1)) + this.checkForNull(matcher.group(2)) : url;
        TextUtils.recycleMatcher((Matcher)matcher);
        return retVal;
    }

    private String checkForNull(String string) {
        return string != null ? string : "";
    }
}

